function [I] = closest( p, C )
%CLOSEST    find i such that the point stored
%           at the i-th row of C is closest to P
%           (Euclidean distance)
%   p - the point (a vector of length 2)
%   C - an n-by-2 matrix, each row represent a point
%   I - the index of point in C that is closest to p 
%       among the points listed in C
%   e.g. p = [1,0], C = [3,0;1,2;0,0]
%      The 3rd point [0,0] is closest among the three points
%      stored in C, in this case we return I = 3.

[~, I] = min((C(:,1)-p(1)).^2 + (C(:,2)-p(2)).^2);

end

