% % zeros(m,n): m-by-n matrix with all zero entries
% % zeros(n): n-by-n matrix with all zeros entries
% A = zeros(4)
% A = zeros(4,2)
% 
% % ones(m,n): m-by-n matrix with all one entries
% % ones(n): n-by-n matrix with all one entries
% A = ones(4)
% A = ones(4,2)
% 
% % repmat(m,n): repeat a matrix vertically m times, horizontally n times
% A = [1 2; 3 4]
% B = repmat(A,2,3)
% C = repmat(A,1,3)
% D = repmat(A,2,1)
% 
% % kron(A,B): return the kronecker tensor product between A and B.
% % !!! kron(A,B) ~= kron(B,A) usually
% % A: m-by-n 
% % B: p-by-r
% % Then kron(A,B) = (m*p)-by-(n*r)
% % Useful to generate block matrix
% A = [1 0; 0 1]
% B = magic(3)
% kron(A,B)
% 
% % linspace: generates linearly spaced vectors.
% % linspace(a,b): return a vector with 100 elements, from a to b
% %                with step size (b-a)/(100-1)
% % linspace(a,b,n): return a vector with n elements, from a to b
% %                with step size (b-a)/(n-1)
% linspace(2,3)
% linspace(2,3,11)
% 1:10 % 1:10 = linspace(1,10,10)
% 1:2:10 % start from 1, with step size 2, the end <= 10.
% 
% % disp: display a string or an array
% disp(ans)
% disp('Hello world!')
% name = 'Simon'; age = 24;
% X = sprintf('%s will be %d this year.', name, age);
% disp(X)
% 
% % mod: Modulus after divison
% % mod(a,b): return the remainder when a divided by b, same sign as b.
% mod(23,5)
% mod(23,-5) % try: >> ans + 5
% 
% % mean: return the average of all elements in a vector
% A = [0 1 1; 2 3 2]
% mean(A)
% mean(A,2)
% b = 1:10
% mean(b) 
% 
% % norm: return the norm of a vector
% % norm(a,1): 1-norm
% % norm(a) / norm(a,2): 2-norm
% % norm(a,Inf): infinity-norm
% norm(b,1)
% norm(b)
% norm(b,Inf)
% 
% % sum: return the sum of all elements in a vector
% % similar to function mean();
% A = [1 5 6; 2 3 2]
% sum(A)
% sum(A,2)
% b = 1:12
% sum(b)
% 
% % clear: clear all the variable(s) 
% % clear variable_name_1 variable_name_2 ...
% % clc: clear all content in the command window
% clear 
% clc
% 
% % abs: return absolute value
% A = [1 -1 2 -2 3 -3];
% abs(A)
% 
% % max/min return the maximum/minimum
% max(A)
% min(A)
% 
% % det: return the determinant of a square matrix 
% A = magic(3)
% det(A)
% 
% % rank: return the rank of a matrix
% A = magic(3)
% rank(A)
% 
% % save/load: useful when you deal with cluster
% % save: save variables as a mat.file
% % load: load the saved file(s)
% % save file_name variable_name_1 variable_name_2 ...
% % load file_name
% a = 1; 
% b = 2;
% c = 3;
% save abc a b c
% clear a b c
% load abc.mat
% 
% % diag(X): return a diagonal matrix whose diagonal part is X.
% X = -5:5
% diag(X)
% 
% % eye(n): return n-by-n identity matrix
% % try eye(m,n) when m ~= n.
% eye(3)
% eye(3,4)
% 
% % floor/round/ceil
% a = 3.415
% floor(a) % return the closest integer s.t. <= a.
% round(a) % return the nearest integer 
% ceil(a) % return the closest integer s.t. >= a.
% 
% % whos: check the name, size, bytes and type of
% %       all (or specific) variable(s) currently in the workspace
% % useful when you are coding with matrix multiplication or debugging.
% whos 
% 
% % rand(m,n): generate m-by-n matrix randomly with all entries in [0,1]
% % rand(n): generate n-by-n matrix randomly with all entries in [0,1]
% % if one want to generate a random matrix (m-by-n) with all entries in [a,b]
% % then we can use (b-a)*rand(m,n)+a
% rand(4)
% 2*rand(4)-1 % in [-1,1]
% 
% % eig: solve eigenvalue(s) and eigenvector(s) of a matrix
% % Type >> doc eig

% m = 500, n = 1000;
% A = rand(n,m); b = sign(rand(m,1)-0.5);
% f = @(w,c) e'*log(1+exp(-b.*(A'*w+c)))/m;
% 
% quadsolver = @(a,b,c) [(-b+sqrt(b^2-4*a*c)/(2*a) (-b-sqrt(b^2-4*a*c)/(2*a)];

