% function gradient_line_search(); 
% min f(x_1,x_2) = exp(x_1+3x_2-0.1) + exp(x_1-3x_2-0.1) + exp(-x_1-0.1) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear
x = [0; 0];  
alpha = 0.1; beta = 0.7;
maxiter = 30; 
frecord = zeros(maxiter,1); 
grecord = zeros(maxiter,1); 
f = @ (x) (exp([1;3]'*x) + exp([1;-3]'*x) + ...
    exp([-1;0]'*x))*exp(-0.1);
gradf = @ (x) (exp([1;3]'*x)*[1;3] +  ...
    exp([1;-3]'*x)*[1;-3] + ...
    exp([-1;0]'*x)*[-1;0])*exp(-0.1);
gradnorm = norm(gradf(x));
iter = 1; tol = 1e-4;

while gradnorm >= tol && iter <= maxiter
    grad = gradf(x); 
    grecord(iter) = norm(grad); 
    fvalx = f(x); 
    frecord(iter) = fvalx; 
    t = 1; 
    y = x - t*grad; %y1 = y(1); y2 = y(2);  
    fvaly = f(y);
    while fvaly >= fvalx - alpha*t*norm(grad)^2
        t = beta*t; 
        y = x - t*grad; %y1 = y(1); y2 = y(2);  
        fvaly = f(y); 
    end
    x = y; %x1 = x(1); x2 = x(2); 
    gradnorm = norm(gradf(x));
    iter = iter + 1;
end

%figure(1); semilogy((1:maxiter),frecord-fs); 
figure(2); semilogy((1:size(grecord,1)),grecord); 
%figure(3); plot(1:maxiter,log10(grecord)); 
%semilogy is better than plot(x,log10(y)).

