%%-------------------------------------------------------------------------
%  Example code for Principal Components Analysis
%  Perform PCA on the given data of 34 cities in China (2002)
%  In this example, normalization is applied
%%-------------------------------------------------------------------------

clear

load cities.mat

n = size(D,1);
X_var = (D - repmat(mean(D),n,1)); % Mean centralize
X_var = X_var./(repmat(std(D),n,1)); % Normalization
Q = (X_var'*X_var)/(n); 

[V,L] = eig(Q); % Q = V*L*V';
[L,I] = sort(diag(L),1,'descend'); % Sorting eigen-value
V = V(:,I);

tol_var = sum(L);
PC = (1:size(D,2))';
L_per = L/tol_var; % rate of contribution
Cum_matrix = (eye(size(L,1)) - diag(ones(1,size(L,1)-1),-1))^(-1);
L_cum_per = Cum_matrix * L_per; % cummulate rate of contribution
disp([PC L_per L_cum_per]); % show the percentage of rate of contribution
% clear Cum_matrix PC X_var Q;

cum_ind = 1; delta = 0.9;
while L_cum_per(cum_ind)< delta
    % determine how many principal directions should be taken
    cum_ind = cum_ind + 1;
end
pca_score = (D*V(:,1:cum_ind))*L_per(1:cum_ind);
pca_score = pca_score/10000;
[pca_score,J] = sort(pca_score,1,'descend');
Y = cell(n,1);
for j=1:size(J,1)
    Y{j} = X{J(j)};
end

figure;
plot(1:size(pca_score,1),pca_score);
hold on;
scatter(1:size(pca_score,1),pca_score);
xlabel('City','Color','b');
ylabel('Score','Color','b');
disp(Y); % show the ranking of cities
