% 2D image decomposition test

% Choose the 10th image
X = double(reshape(dog(:,10),64,64));
[xM,xH,xV,xD]=haar2d(X);

% show the decomposition
figure;
subplot(2,2,1), imshow(uint8(xM));
subplot(2,2,2), imshow(uint8(xH));
subplot(2,2,3), imshow(uint8(xV));
subplot(2,2,4), imshow(uint8(xD));





pause;

nbcol = size(colormap(gray),1);
xH1 = wcodemat(xH,nbcol);
xV1 = wcodemat(xV,nbcol);
edge = xH1 + xV1;

% show the edge detection after rescaling
figure
subplot(2,2,1), imshow(uint8(xH1));
subplot(2,2,2), imshow(uint8(xV1));
subplot(2,2,3), imshow(uint8(edge));
subplot(2,2,4), imshow(uint8(X));


