% PCA analysis

clear all;

load dogData;
load catData;

dog1 = edgedetect(dog);
cat1 = edgedetect(cat);

X = [dog1, cat1];

[U,S,V] = svd(X,0);     % reduced SVD


% Consider the singular values
S1 = diag(S);
figure(1)
plot(S1,'o');



% Consider the projection in first 3 modes
% for the first 40 dog/cat images
figure(2);
for j=1:3
    
    subplot(3,2,2*j-1);
    
    plot(S1(j)*V(1:40,j),'o-');
    
    subplot(3,2,2*j);
    
    plot(S1(j)*V(81:120,j),'o-');
    
end



% Show the first 4 columns in the matrix U
figure(3);
nbcol = size(colormap(gray),1);
for j=1:4
    
    subplot(2,2,j);
    
    u1 = U(:,j);
    u2 = wcodemat(u1,nbcol);
    u3 = reshape(u2,32,32);
    imshow(uint8(u3));
    
end









