img = imread('cat0.jpg');
mean_img = mean(img, 3);
% Application of FFT
% Convert the image to the spectral domain using FFT
freq = fft2(mean_img);
freq = fftshift(freq);
freq_show = log(abs(freq) + 1);
freq_show = freq_show / max(freq_show(:));
figure;imshow(freq_show);title('Spectrum');
 
mid = floor(size(freq) / 2);
disp(mid);
% Create a mask to remove the low frequency information in the middle
mask = ones(size(freq));
r = 20;
mask(mid(1)-r:mid(1)+r, mid(2)-r:mid(2)+r) = 0;
%mask = 1-mask;
freq = freq .* mask;
freq_show = log(abs(freq) + 1);
freq_show = freq_show / max(freq_show(:));
figure;imshow(freq_show);title('Modified Spectrum');
 
% Convert the image back to the spatial domain using inverse FFT
freq = ifftshift(freq);
output3 = ifft2(freq);
output_img = abs(output3);
figure;imshow(output_img/255);title('Filtered Image');
