function output = convolution(image, kernel)
    [h, w] = size(image);
    [kh, kw] = size(kernel);
    assert(kh == kw);
    pad = floor((kh-1) / 2);
    pad_img = padarray(image, [pad, pad]);
    output = zeros(h, w);
    for i = 1:h
        for j = 1:w
            output(i, j) = sum(sum(pad_img(i:i+kh-1, j:j+kw-1) .* kernel));
        end
    end
end