%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MATH3360 Tutorial 5 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

img = imresize(imread('img1.jpg'), [1024, 1024]);
img = double(rgb2gray(img));


%% Compute DFT

% Be carefull that the defintion of DFT in matlab and lecture is differed by
% a scalar multiple. 
dft = fft2(img);
d = disp_dft(dft);

%% Compute DFT for shifted and rotated images

shift_down = 100;
shift_right = 200;

% Lazy way, you can code a better approach
img_periodic = [img, img, img; img, img, img; img, img, img];
img_shift = img_periodic((1025 - shift_down):(2048 - shift_down), (1025 - shift_right):(2048 - shift_right));

d_shift = disp_dft(fft2(img_shift), false);

img_rot90 = rot90(img);
d_rot90 = disp_dft(fft2(img_rot90), false);

figure;
montage({uint8(img), d, uint8(img_shift), d_shift, uint8(img_rot90), d_rot90}, 'size', [3, 2]);

%% Applying Low Pass Filters

d0 = 100;
dft_ilpf = ILPF(dft, d0);
d_ilpf = disp_dft(dft_ilpf, false);

img_ilpf = abs(ifft2(dft_ilpf));

figure;
montage({uint8(img), d, uint8(img_ilpf), d_ilpf}, 'size', [2, 2]);

%% Low Pass Filter

function d = dist(m, n)
    dist_to_upper_left = sqrt(m^2 + n^2);
    dist_to_upper_right = sqrt(m^2 + (1025 - n)^2);
    dist_to_lower_left = sqrt((1025 - m)^2 + n^2);
    dist_to_lower_right = sqrt((1025 - m)^2 + (1025 - n)^2);
    
    d = min([dist_to_upper_left, dist_to_upper_right, dist_to_lower_left, dist_to_lower_right]);
end

function dft_new = ILPF(dft, d0)
    dft_new = dft;
    for m = 1:1024
        for n = 1:1024
            if dist(m, n) > d0
                dft_new(m, n) = 0;
            end
        end
    end
end

%% Function for displaying DFT

function d_new = disp_dft(dft, show)
    magn = abs(dft);
    d = log(1 + magn);
    
    d_max = max(d, [], 'all');
    d_min = min(d, [], 'all');
    d_new = uint8(round((d - d_min) / (d_max - d_min) * 255));
    
    % Centralization
    d_periodic = [d_new, d_new; d_new, d_new];
    d_new = d_periodic(513:1536, 513:1536);
    
    if (nargin < 2) || (show)
        figure;
        imshow(d_new);
    end
end

