%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MATH3360 Tutorial 2 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
img1 = imread('img1.jpg');
montage({img1});

%% RGB -> Grayscale
img1_gray = rgb2gray(img1);
montage(img1_gray);

%% 
% Convert the grayscale image to 
% double for further computation.
img1_gray = double(img1_gray);
% You can also try to perform SVD on each color.

%% SVD 1
S = svd(img1_gray);
% disp(S); % Only the singular values
% Matlab set the singular values in descending order.

S_cumsum = cumsum(S) / sum(S);
plot(1:length(S), S_cumsum);
% A cumulative sum plot, 
% x-axis means the number of components, 
% y-axis means the percentage of details.

% Number of Singular Values with given percentage of details
nsv_25 = sum(S_cumsum < 0.25); % 17
nsv_50 = sum(S_cumsum < 0.5); % 114
nsv_75 = sum(S_cumsum < 0.75); % 294
nsv_90 = sum(S_cumsum < 0.9); % 493

%% SVD 2
[U, S, V] = svd(img1_gray);
% disp(size(U)); % (852, 852)
% disp(size(S)); % (852, 1280)
% disp(size(V)); % (1280, 1280)

disp(sum(sum(abs((U * S * V' - img1_gray))))); % close to 0

%% SVD 3
% SVD in more economic way, saving memory and computation.
[U, S, V] = svd(img1_gray, 'econ');
% disp(size(U)); % (852, 852)
% disp(size(S)); % (852, 852)
% disp(size(V)); % (852, 1280)

disp(sum(sum(abs((U * S * V' - img1_gray))))); % close to 0

%% Image Compression with SVD
S_diag = diag(S); % a column vector of singular values

% Only the first component
S_diag1 = S_diag;
S_diag1(2:length(S_diag)) = 0;
% 25% of details
S_diag25 = S_diag;
S_diag25((nsv_25+1):length(S_diag)) = 0;
% 50% of details
S_diag50 = S_diag;
S_diag50((nsv_50+1):length(S_diag)) = 0;
% 75% of details
S_diag75 = S_diag;
S_diag75((nsv_75+1):length(S_diag)) = 0;
% 90% of details
S_diag90 = S_diag;
S_diag90((nsv_90+1):length(S_diag)) = 0;

img1_gray = uint8(img1_gray);
img1_comp1 = uint8(U * diag(S_diag1) * V');
img1_comp25 = uint8(U * diag(S_diag25) * V');
img1_comp50 = uint8(U * diag(S_diag50) * V');
img1_comp75 = uint8(U * diag(S_diag75) * V');
img1_comp90 = uint8(U * diag(S_diag90) * V');

montage({img1_gray, img1_comp1, img1_comp25, img1_comp50, img1_comp75, img1_comp90}, 'size', [2, 3]);

%% Remarks
% Originally, an image needs H*W numbers to store.
% After compression using N componets (using N singular 
% values), only first N columns of U and V are needed. 
% So it only needs (H + W) * N numbers to keep the 
% components of U and V, and N numbers to keep the 
% singular values. Totally (H + W + 1) * N numbers.









