#ifndef ROLLING_BALL_H
#define ROLLING_BALL_H

#include "GL4D/gl4d.h"

GL4DAPI typedef struct {
    double x;
    double y;
    double z;

    /* row, column */
    double m[4][4];
} gl4d_rb_state_t;

GL4DAPI void gl4d_rb_state_init(gl4d_rb_state_t *state);
GL4DAPI void gl4d_rb_state_reset(gl4d_rb_state_t *state);
GL4DAPI void gl4d_rb_3d(gl4d_rb_state_t *state, double x, double y);
GL4DAPI void gl4d_rb_4d(gl4d_rb_state_t *state, double x, double y, double z);

GL4DAPI void gl4d_rb_load_matrix(
    const gl4d_rb_state_t *state, void (*func)(GL4Dfloat *m));

#endif /* ROLLING_BALL_H */

