/*
 * Copyright (c) 2004-2008 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2011 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2011 Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2012      Oak Ridge National Labs.  All rights reserved.
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */


#include "orte_config.h"
#include "orte/constants.h"

#include "opal/mca/mca.h"
#include "opal/util/output.h"
#include "opal/mca/base/base.h"

#include "orte/mca/ess/base/base.h"

/*
 * The following file was created by configure.  It contains extern
 * statements and the definition of an array of pointers to each
 * module's public mca_base_module_t struct.
 */

#include "orte/mca/ess/base/static-components.h"

opal_list_t orte_ess_base_components_available;
orte_ess_base_module_t orte_ess = {
    NULL,  /* init */
    NULL,  /* finalize */
    NULL,  /* abort */
    NULL,  /* proc_get_locality */
    NULL,  /* proc_get_daemon */
    NULL,  /* proc_get_hostname */
    NULL,  /* get_local_rank */
    NULL,  /* get_node_rank */
    NULL,  /* proc_get_epoch */
    NULL,  /* update_pidmap */
    NULL,  /* update_nidmap */
    NULL   /* ft_event */
};
int orte_ess_base_output;
int orte_ess_base_std_buffering = -1;

int
orte_ess_base_open(void)
{
    mca_base_param_reg_int_name("ess_base",
                                "stream_buffering",
                                "Adjust buffering for stdout/stderr "
                                "[-1 system default] [0 unbuffered] [1 line buffered] [2 fully buffered] "
                                "(Default: -1)",
                                false, false,
                                -1, &orte_ess_base_std_buffering);

    orte_ess_base_output = opal_output_open(NULL);
    
    OBJ_CONSTRUCT(&orte_ess_base_components_available, opal_list_t);

    /* Open up all available components */
    if (ORTE_SUCCESS != 
        mca_base_components_open("ess", orte_ess_base_output, mca_ess_base_static_components, 
                                 &orte_ess_base_components_available,
                                 true)) {
        /* error message emitted by fn above */
        return ORTE_ERR_SILENT;
    }

    return ORTE_SUCCESS;
}
