#ifndef __MKRSA_HEADER_INCLUDED__
#define __MKRSA_HEADER_INCLUDED__



#include "crypto.h"



#define MKRSA_MAX_KEY_STRING_LEN 4096

//////////////////////////////////////////////////////////////
// public key exponent used for key generation
#define MKRSA_DEFAULT_PUBLIC_EXPONENT 65537
#define MKRSA_RANDOM_PUBLIC_EXPONENT 0


//////////////////////////////////////////////////////////////
// mapping of each key parameter to key struct's array element
#define MKRSA_NUM_PARAM 3

#define MKRSA_PARAM_EXPONENT         0
#define MKRSA_PARAM_MODULUS          1
#define MKRSA_PARAM_PHI              2


//////////////////////////////////////////////////////////////
// key type definition
typedef CRYPTO_KEY MKRSA_KEY;
typedef CRYPTO_KEY MKRSA_PUBLIC_KEY;
typedef CRYPTO_KEY MKRSA_PRIVATE_KEY;

typedef CRYPTO_KEY_PAIR MKRSA_KEY_PAIR;


//////////////////////////////////////////////////////////////
// RSA function prototypes
BOOL MKRSA_NewKeyPair(MKRSA_KEY_PAIR *key_pair, unsigned int bit_length, unsigned long pub_exp_int);
BOOL MKRSA_NewReEncryptionKeyPair(MKRSA_KEY_PAIR *new_pair, MKRSA_KEY base_key);


BOOL MKRSA_Encrypt(char cipher[], int *out_len, char data[], int in_len, RSA_KEY key);
BOOL MKRSA_ReEncrypt(char cipher[], int *out_len, char data[], int in_len, RSA_KEY key);
BOOL MKRSA_Decrypt(char data[], int *out_len, char cipher[], int in_len, RSA_KEY key);


#endif /* __RSA_HEADER_INCLUDED__ */
