#ifndef __CRYPTO_HEADER_INCLUDED__
#define __CRYPTO_HEADER_INCLUDED__



#include <gmp.h>


typedef unsigned char BOOL;
#define FALSE 0
#define TRUE  1


//////////////////////////////////////////////////////////////
// supporting types of encryption/decryption key
#define CRYPTO_KEY_UNDEFINED 0
#define CRYPTO_KEY_RSA       1
#define CRYPTO_KEY_MAX_VALID 1


//////////////////////////////////////////////////////////////
// generic key struct for encryption/decryption keys
typedef struct {
    unsigned int type;
    unsigned int num_param;
    mpz_t *param;
} CRYPTO_KEY;


typedef struct {
	unsigned int type;	
	CRYPTO_KEY public_key;
	CRYPTO_KEY private_key;	
} CRYPTO_KEY_PAIR;


//////////////////////////////////////////////////////////////
// function prototypes

void CRYPTO_InitKey(CRYPTO_KEY *key);
void CRYPTO_InitKeyPair(CRYPTO_KEY_PAIR *key_pair);

void CRYPTO_DestroyKey(CRYPTO_KEY *key);
void CRYPTO_DestroyKeyPair(CRYPTO_KEY_PAIR *key_pair);

BOOL CRYPTO_NewKeyPair(CRYPTO_KEY_PAIR *key_pair, unsigned int bit_length, unsigned int pub_exp, unsigned int key_type);
BOOL CRYPTO_LoadKeyPair(CRYPTO_KEY_PAIR *key_pair, char key_filename[], char passwd[], unsigned int key_type);
BOOL CRYPTO_SaveKeyPair(CRYPTO_KEY_PAIR key_pair, char key_filename[], char passwd[]);

CRYPTO_KEY* CRYPTO_CopyKey(CRYPTO_KEY *dest, CRYPTO_KEY src);
CRYPTO_KEY* CRYPTO_CopyPublicKey(CRYPTO_KEY *dest, CRYPTO_KEY_PAIR src);
CRYPTO_KEY* CRYPTO_CopyPrivateKey(CRYPTO_KEY *dest, CRYPTO_KEY_PAIR src);

char* CRYPTO_KeyToString(char *buffer, CRYPTO_KEY key);
char* CRYPTO_KeyPairToString(char *buffer, CRYPTO_KEY_PAIR key_pair);
int CRYPTO_KeyToStringAlloc(char **buffer, CRYPTO_KEY key);
int CRYPTO_KeyPairToStringAlloc(char **buffer, CRYPTO_KEY_PAIR key_pair);
int CRYPTO_GetKeyStringLength(CRYPTO_KEY key);
int CRYPTO_GetKeyPairStringLength(CRYPTO_KEY_PAIR key_pair);

BOOL CRYPTO_ParseKeyFromString(CRYPTO_KEY *key, char *buffer);
BOOL CRYPTO_ParseKeyPairFromString(CRYPTO_KEY_PAIR *key_pair, char *buffer);

BOOL CRYPTO_Encrypt(char cipher[], int *out_len, char data[], int in_len, CRYPTO_KEY key);
BOOL CRYPTO_Decrypt(char data[], int *out_len, char cipher[], int in_len, CRYPTO_KEY key);

BOOL CRYPTO_SignPublicKey(char cipher[], int *out_len, CRYPTO_KEY_PAIR pair);
BOOL CRYPTO_CheckSignedPublicKey(char cipher[], int in_len, CRYPTO_KEY key);

BOOL CRYPTO_CompareKey(CRYPTO_KEY key1, CRYPTO_KEY key2);

unsigned int CRYPTO_GetPlaintextUnitSize(CRYPTO_KEY key);
unsigned int CRYPTO_GetCipherUnitSize(CRYPTO_KEY key);

void CRYPTO_AddKeyToListFile(CRYPTO_KEY key, char user_name[], char filename[]);
void CRYPTO_RemoveKeyFromListFile(CRYPTO_KEY key, char filename[]);
void CRYPTO_RemoveUserFromListFile(char user_name[], char filename[]);
BOOL CRYPTO_QueryUserFromListFile(char user_name[], int name_buf_size, CRYPTO_KEY key, char filename[]);

#endif /* __CRYPTO_HEADER_INCLUDED__ */
