/* MBFCT.C
   MODIFIED Bellmann-Ford algorithm. 
   Tarjan strategy - scanning successor list and removing nodes from queue
*/

node* spc ( n, node_first, source )

long n;             /* number of nodes */

node *node_first,   /* pointer to the first node */
     *source;       /* pointer to the source */
{
long num_scans = 0; /* statistic - number of scans */
node* returnspc;


node* spc123 ( n, node_first, source )

long n;             /* number of nodes */

node *node_first,   /* pointer to the first node */
     *source;       /* pointer to the source */

{

node *node_from,    /* scanning node */
     *node_to,      /* node on the head of the arc */
     *node_stop,    /* fiction: node after the last in the network */
     *node_test,    /* current node for detecting negative cycle */
     *after,        /* next node in the successor list */
     *before,       /* previous node in the successor list */
     *i;            /* current node */

arc  *arc_ij,       /* current arc */
     *arc_stop;     /* the next arc after the last arc going from current node */

long dist_new,      /* distance to node_to via node_from */
     dist_from;     /* distance of node_from */

long total_degree;  /* sum of degrees of scanned nodes */

int  n_status;      /* status of node extracted from the queue */

/* initialization */


//source -> dist   = 0;
source -> parent = source;
source -> t_next = source;
source -> t_prev = source;

INIT_QUEUE ( source )

/* main loop */
while ( NONEMPTY_QUEUE )
 {
   EXTRACT_FIRST_WITH_STATUS ( node_from );

   n_status            = node_from -> status;
   node_from -> status = OUT_OF_QUEUE;
   node_from -> not_start = 1;

   if ( n_status == INACTIVE ) continue;

   dist_from = node_from -> dist;

   FOR_ALL_ARCS_FROM_NODE ( node_from, arc_ij )  
     { 
       /* scanning arcs outgoing from  node_from  */
       node_to  = arc_ij -> head;

       dist_new = dist_from + ( arc_ij -> len );

       if  (dist_new < node_to -> dist) 
	   { 
	   num_scans ++;
	     node_to -> dist = dist_new;

	     if ( node_to -> t_prev != NNULL )
	       {	     
		 /* searching negative cycle and changing the tree */
		 before = node_to -> t_prev;

		 for ( node_test = node_to, total_degree = 0; 
		      total_degree >= 0;
		      node_test = node_test -> t_next
		     )
		   {
		     if ( node_test == node_from )
		       {
			 n_scans = num_scans;
			 node_to -> parent = node_from;
			 return node_from;
		       }
		     
		     total_degree += node_test -> degree;

		     node_test -> t_prev = NNULL;
		     node_test -> degree = -1;

		     if ( node_test -> status == ACTIVE )
		       node_test -> status = INACTIVE;
		   }
		 /* branch is scanned - negative cycle is not found */
	     
	    	 (node_to -> parent) -> degree -- ;
		 before     -> t_next = node_test;
		 node_test  -> t_prev = before;
	       }
             node_to -> parent = node_from;
             ( node_from -> degree ) ++ ;

	     after = node_from -> t_next;
	     
	     node_from -> t_next = node_to;
	     node_to   -> t_prev = node_from;

	     node_to   -> t_next = after;
	     after     -> t_prev = node_to;

	     MAKE_ACTIVE ( node_to )
	   }
     } /* end of scanning  node_from */
 } /* end of the main loop */

return NNULL;
}

node *tam_i;

//printf("running\n");
for (tam_i = node_first; tam_i < node_first + n; tam_i++)
   { 
      tam_i -> parent = NNULL;
      tam_i -> dist   = VERY_FAR;
      tam_i -> t_prev = NNULL;
      tam_i -> status = OUT_OF_QUEUE;
      tam_i -> degree = -1;
      tam_i -> not_start = 0;
   }

for (tam_i = node_first; tam_i < node_first + n; tam_i++)
{
	if (tam_i -> not_start == 0)
	returnspc =  spc123 ( n, node_first, tam_i);

	n_scans = num_scans;
	if (returnspc != NNULL)
	return returnspc;
}

}
