#include "ioBP.h"
#include <vector>
#include <map>
using namespace std;

long long n;

int queryCnt;

char * txtName, * degName, * outName, *bpoutName, * bpdegName, * bpsName, * bpsrName;

edgeL * deg;
edgeS * labelout;
edgeS * labelx, * labely;

bool fc = 0;

long long sum;


int query(int x, int y)
{
	if (x == y) return 0;
	int xx = x, yy = y;

	x = ((deg[xx].x<<32)>>32);
	y = ((deg[yy].x<<32)>>32);
	
	if (x > y)
	{
		labelx = labelout + deg[xx].w;
		labely = labelout + deg[yy].y;
	}
	else
	{
		int xy = x; x = y; y = xy;
		labelx = labelout + deg[yy].y;
		labely = labelout + deg[xx].w;
	}
	
	int ans = 10000, i = 0, j = 0;
	
	
	if (labelx[i].x != -1 && labely[j].x != -1)
	while (labelx[i].x < y)
	{
		if (labelx[i].x == labely[j].x) 
		{
			ans = ans>(labelx[i].w + labely[j].w)?(labelx[i].w + labely[j].w):ans;
			if (labelx[++i].x == -1) break;
			if (labely[++j].x == -1) break;
		}
		else if (labelx[i].x < labely[j].x)
		{
			if (labelx[++i].x == -1) break;
		}
		else if (labely[++j].x == -1) break;
	}
	
	while (labelx[i].x != -1 && labelx[i].x < y) i++;
	if (labelx[i].x == y) ans = ans>labelx[i].w?labelx[i].w:ans;
	
		
	return ans;
}


void loadIndex()
{
	inBufL degBuf(degName);
	inBufS outLabel(outName);
	
	n = checkB(degName)/sizeof(edgeL);

	deg = (edgeL *)malloc(sizeof(edgeL)*n);
	labelout = (edgeS*)malloc(checkB(outName));

	printf("%lld vertices\n", n);

	degBuf.start();
	for (int i = 0; i < n; i++)
		degBuf.nextEdge(deg[i]);
	
	outLabel.start();
	for (int i = 0; !outLabel.isEnd; i++)
		outLabel.nextEdge(labelout[i]);

}


struct bp
{
	long long s0, s1;
	wtype w;
};

void build(int nBP)
{
	FILE * gFile = fopen(txtName, "r");
	
	fscanf(gFile, "%lld", &n);
	
	vector<int> invid(n);
	for (int i = 0; i < n; i++)
		invid[(deg[i].x<<32)>>32] = i;
	
	vector<bool> usd(n, 0);
	vector<edge> sr;
	
	vector< vector<int> > adj(n);

	int x, y, w;
	while (fscanf(gFile, "%d%d%d", &x, &y, &w)!= EOF)
	{
		adj[x].push_back((deg[y].x<<32)>>32);		
	}
	
	for (int i = 0; i < n; i++)
		sort(adj[i].begin(), adj[i].end());
	
	
	vector< vector<edgeS> > invout(n);
	vector< vector<edgeBP> > membp(n);
	
	edgeS tmp;
	edgeBP tmpbp;

	for (long long i = 0, j = 0; i < n; i++, j++)
		while (labelout[j].x != -1)
		{
			tmp.x = invid[i];
			tmp.w = labelout[j].w;
			invout[invid[labelout[j].x]].push_back(tmp);
			
//			if (labelout[j].x == 0 && invid[i] == 24775)	printf("%d\n", tmp.w);
			j++;
		}
	
	
	
	long long snew = 0, sroot = 0, snei = 0, snot = 0;
	sum = checkB(outName)/sizeof(edgeS);
	
	int r;
	map<int,bp> bpdis;
	for (int i = 0, r = 0; i < nBP; i++)
	{
		while (r < n && usd[r]) r++;
		if (r == n) break;
		
		usd[r] = 1;

		bpdis.clear();
		
		sroot += invout[invid[r]].size();

		while (invout[invid[r]].size() > 0)
		{
			sum--;
			tmp = invout[invid[r]].back();
			invout[invid[r]].pop_back();
			bpdis[tmp.x].w = tmp.w;
			bpdis[tmp.x].s0 = bpdis[tmp.x].s1 = 0;
			
		}

		
		unsigned long long s0 = 0, s1 = 0;
		
		for (int j = 0, x, cnt = 0; j < adj[invid[r]].size(); j++)
			if (!usd[adj[invid[r]][j]])
			{
				usd[adj[invid[r]][j]] = 1;

				x = invid[adj[invid[r]][j]];
				
				sr.push_back(edge(adj[invid[r]][j], i, cnt));
				
				
				snei += invout[x].size();
				while (invout[x].size() > 0)
				{
					sum--;
					tmp = invout[x].back();
					invout[x].pop_back();
					
					if (bpdis.find(tmp.x) == bpdis.end())
					{
						snot++;
						bpdis[tmp.x].w = query(invid[r], tmp.x);
						bpdis[tmp.x].s0 = bpdis[tmp.x].s1 = 0;
					}
					
					if (bpdis[tmp.x].w == tmp.w)
					{
						bpdis[tmp.x].s0 |= (1ULL << cnt);
					}
					else if (bpdis[tmp.x].w == tmp.w + 1)
					{
						bpdis[tmp.x].s1 |= (1ULL << cnt);
					}

				}
				
				if (++cnt == 64) break;
			}
		
		sum += bpdis.size();
		snew += bpdis.size();
		
		for (map<int, bp>::iterator it = bpdis.begin(); it != bpdis.end(); it++)
		{
			tmpbp.s0 = it->second.s0;
			tmpbp.s1 = it->second.s1;
			tmpbp.x = i;
			tmpbp.w = it->second.w;
			
			membp[it->first].push_back(tmpbp);
			
		}
//		printf("%d\n", r);

	}
	
	{
	
	outBufL bpdegBuf(bpdegName);
	outBufS bpoutBuf(bpoutName);
	outBufBP bpsBuf(bpsName);
	outBuf bpsrBuf(bpsrName);
	
	
	edgeBP tmpBP;
	tmpBP.x = -1;
	
	for (long long i = 0, j, nout = 0, ns = 0; i < n; i++)
	{
		sort(membp[i].begin(), membp[i].end());	

		bpdegBuf.insert(deg[i].x, nout, ns);

		for (j = deg[i].y; labelout[j].x != -1; j++)
		{
			if (!usd[labelout[j].x]) 
			{
				bpoutBuf.insert(labelout[j].x, labelout[j].w);
				nout++;
			}
		}	
		bpoutBuf.insert(-1, 0);
		nout++;
		
		for (vector<edgeBP>:: iterator it = membp[i].begin(); it != membp[i].end(); it++)
		{
			bpsBuf.insert(*it);
			ns++;
		}
		
		bpsBuf.insert(tmpBP);
		ns++;
		
	}
	
	
	for (int i = 0; i < sr.size(); i++)
		bpsrBuf.insert(sr[i]);
	
	}
		
	printf("indexSize %lf (MB)\n", (checkB(bpdegName) + checkB(bpoutName) + checkB(bpsName) + checkB(bpsrName) )/(1024.0*1024) );
	
	

}











int main(int argc, char ** argv)
{
	txtName = argv[1];
	degName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(degName, "%s.deg", txtName);
	
	outName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(outName, "%s.out", txtName);

	bpdegName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(bpdegName, "%s.bpdeg", txtName);


	bpoutName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(bpoutName, "%s.bpout", txtName);

	bpsName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(bpsName, "%s.bps", txtName);

	bpsrName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(bpsrName, "%s.bpsr", txtName);

	timer tm;
	
	loadIndex();
	
	
	int tt = 50;
	if (argc > 2) tt = atoi(argv[2]);
	
	build(tt);	
		
	printf("to bit parallel time: %lf (sec)\n", tm.getTime());
	remove(degName);
	remove(outName);


	
	
	free(degName);
	free(outName);
	
	free(deg);
	free(labelout);
	
	return 0;
}














