#include "ioBP.h"
#include <malloc.h>
#include <stdint.h>
#include <xmmintrin.h>
#include <sys/time.h>
#include <climits>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <algorithm>
#include <fstream>
#include <utility>

using namespace std;

long long n;

int queryCnt;

char * txtName, * degName, * outName, * sName, * srName;

edgeL * deg;
edgeS * labelout;
edgeS * labelx, * labely;

wtype * bpw, * xw, * yw;
unsigned long long * s0, * s1, * xs0, * xs1, * ys0, * ys1, *bpos;

const int nbp = 50;

char invpos[1000];

bool fc = 0;

bool *bsr;

map<int, pair<int,unsigned long long> > sr;


int scanbp = 0, scanout = 0;
timer tm;

inline int query(int x, int y)
{

	if (x == y) return 0;
	int xx = x, yy = y;
	long long dx = (long long)xx * nbp, dy = (long long)yy * nbp;

	x = ((deg[xx].x<<32)>>32);
	y = ((deg[yy].x<<32)>>32);
	
	long long ii, jj;
	
	if (x > y)
	{
		xw = bpw + dx;
		xs0 = s0 + dx;
		xs1 = s1 + dx;

		yw = bpw + dy;
		ys0 = s0 + dy;
		ys1 = s1 + dy;

		labelx = labelout + deg[xx].y;
		labely = labelout + deg[yy].y;
	}
	else
	{
		int xy = x; x = y; y = xy;

		xw = bpw + dy;
		xs0 = s0 + dy;
		xs1 = s1 + dy;

		yw = bpw + dx;
		ys0 = s0 + dx;
		ys1 = s1 + dx;

		labelx = labelout + deg[yy].y;
		labely = labelout + deg[xx].y;
	}
	
	unsigned long long pos = (bpos[xx] & bpos[yy]), lb;
	
	int ans = 10000, i = 0, j = 0, dis;
	
	
	while (pos)
	{
		scanbp++;
		pos -= (lb = (pos & (-pos)));
				
		i = invpos[lb%1000] ;
		
		dis = xw[i] + yw[i];
		{
		if (xs1[i] & ys1[i])
			ans = dis - 2 < ans ? dis - 2 : ans;
		else if ((xs1[i] & ys0[i]) || (xs0[i] & ys1[i]))
			ans = dis - 1 < ans ? dis - 1 : ans;
		else ans = dis < ans ? dis : ans;
		}

	}

	if (!bsr[y])
	{
		int r = sr[y].first;
		unsigned long long rcnt = sr[y].second;
		if (xs0[r] & rcnt)
			ans = xw[r] < ans ? xw[r] : ans;
		else if (xs1[r] & rcnt)
			ans = xw[r] < ans - 1 ? xw[r] : ans - 1;
		
	}

	
	
	

	
	i = 0, j = 0;
	
	if (labelx[i].x != -1 && labely[j].x != -1)
	while (labelx[i].x < y)
	{
		scanout++;

		if (labelx[i].x == labely[j].x) 
		{
			ans = ans>(labelx[i].w + labely[j].w)?(labelx[i].w + labely[j].w):ans;

			if (labelx[++i].x == -1) break;
			if (labely[++j].x == -1) break;
		}
		else if (labelx[i].x < labely[j].x)
		{
			if (labelx[++i].x == -1) break;
		}
		else if (labely[++j].x == -1) break;
	}
	
	while (labelx[i].x != -1 && labelx[i].x < y) i++;
	if (labelx[i].x == y) ans = ans>labelx[i].w?labelx[i].w:ans;
	
	return ans;
}


void loadIndex()
{
	inBufL degBuf(degName);
	inBufS outLabel(outName);
	inBufBP bpsBuf(sName);
	inBuf bpsrBuf(srName);
	
	n = checkB(degName)/sizeof(edgeL);

	deg = (edgeL *)malloc(sizeof(edgeL)*n);
	labelout = (edgeS*)malloc(checkB(outName));
	bsr = (bool*)malloc(n);

	bpw = (wtype*)malloc(n * nbp * sizeof(wtype));
	s0 = (unsigned long long*)malloc(n * nbp * sizeof(unsigned long long));
	s1 = (unsigned long long*)malloc(n * nbp * sizeof(unsigned long long));
	bpos = (unsigned long long*)malloc(n * sizeof(unsigned long long));


	printf("%lld\n", n);

	degBuf.start();
	
	for (int i = 0; i < n; i++)
	{
		degBuf.nextEdge(deg[i]);
		bsr[i] = 1;
	}
	
	outLabel.start();
	for (int i = 0; !outLabel.isEnd; i++)
		outLabel.nextEdge(labelout[i]);

	bpsBuf.start();
	edgeBP tmpbp;
	
	for (long long i = 0; i < n; i++)
		for (bpos[i] = 0, bpsBuf.nextEdge(tmpbp); tmpbp.x != -1; bpsBuf.nextEdge(tmpbp))
		{
			bpw[i*nbp + tmpbp.x] = tmpbp.w;
			s0[i*nbp + tmpbp.x] = tmpbp.s0;
			s1[i*nbp + tmpbp.x] = tmpbp.s1;
			bpos[i] |= (1ULL << tmpbp.x);			
		}
	

	bpsrBuf.start();
	edge tmp;
	for (int i = 0; !bpsrBuf.isEnd; i++)
	{
		bpsrBuf.nextEdge(tmp);
		sr[tmp.x] = make_pair(tmp.y, (1ULL << tmp.w));
		bsr[tmp.x] = 0;
	}
	
	for (int i = 0; i < nbp; i++)
		invpos[(1ULL<<i)%1000] = i;
	
	
}


int main(int argc, char ** argv)
{
	txtName = argv[1];

	degName = (char*)malloc(1+strlen(txtName) + nbp);
	sprintf(degName, "%s.bpdeg", txtName);

	outName = (char*)malloc(1+strlen(txtName) + nbp);
	sprintf(outName, "%s.bpout", txtName);

	sName = (char*)malloc(1+strlen(txtName) + nbp);
	sprintf(sName, "%s.bps", txtName);

	srName = (char*)malloc(1+strlen(txtName) + nbp);
	sprintf(srName, "%s.bpsr", txtName);

	
	loadIndex();
	
	printf("load time %lf (ms)\n", tm.getTime()*1000);
	

	double sumTime = 0;
	
	
	queryCnt = 1000;
	if (argc > 2) queryCnt = atoi(argv[2]);

	int cnt = 0;
	
	
	vector<int> qx(queryCnt), qy(queryCnt);
	
	for (int i = 0 ; i < queryCnt; i++)
	{
		qx[i] = rand()%n;
		qy[i] = rand()%n;
	}

	
	tm.restart();
	for (int i = 0; i < queryCnt; i++)
	{
		query(qx[i], qy[i]);		
	}
	sumTime += tm.getTime();
	
	printf("average query time %lf (mirco second)\n", sumTime*1e6/queryCnt);

	free(degName);
	free(outName);
	
	free(deg);
	free(labelout);
	free(bsr);
	
	free(s0);
	free(s1);
	free(bpw);
	free(bpos);
	
	return 0;
}



















