#include "ioU.h"

struct edgeBP64
{
	unsigned long long s0, s1;
	int x, w;
}__attribute__((aligned(64))); 


struct edgeBP
{
	unsigned long long s0, s1;
	int x;
	wtype w;
	bool operator < (const edgeBP & edgeTmp) const
	{
		return x < edgeTmp.x;
	}

}__attribute__((packed));


struct inBufBP
{
	edgeBP *buf;
	int cnt, bufLen;
	FILE *inFile;
	bool isEnd;
	int perBuf;
	inBufBP()	{}
	inBufBP(char *fileName)
	{
		perBuf = bufSize / sizeof(edgeBP);
		buf = (edgeBP*)malloc(sizeof(edgeBP) * perBuf);		
		inFile = fopen(fileName, "rb");
	}
	
	void start()
	{
		timer tm;
		cnt = 0;
		iCnt++;
		bufLen = fread(buf, sizeof(edgeBP), perBuf, inFile);
		isEnd = (bufLen == 0);
		tRead += tm.getTime();
		
	}
	~inBufBP()
	{
		if (inFile != NULL)	fclose(inFile);
		free(buf);
	}
	void nextEdge(edgeBP & tmpEdge)
	{
		if (cnt < bufLen - 1)
		{
			tmpEdge = buf[cnt++];
		}
		else 
		{
			timer tm;
			iCnt++;
			tmpEdge = buf[cnt];
			bufLen = fread(buf, sizeof(edgeBP), perBuf, inFile);
			cnt = 0;
			isEnd = (bufLen == 0);
			tRead += tm.getTime();
		}
	}

	void nextEdge(edgeBP64 & tmpEdge)
	{
		if (cnt < bufLen - 1)
		{
			tmpEdge.s0 = buf[cnt].s0;
			tmpEdge.s1 = buf[cnt].s1;
			tmpEdge.x = buf[cnt].x;
			tmpEdge.w = buf[cnt++].w;
		}
		else 
		{
			timer tm;
			iCnt++;
			tmpEdge.s0 = buf[cnt].s0;
			tmpEdge.s1 = buf[cnt].s1;
			tmpEdge.x = buf[cnt].x;
			tmpEdge.w = buf[cnt++].w;
			bufLen = fread(buf, sizeof(edgeBP), perBuf, inFile);
			cnt = 0;
			isEnd = (bufLen == 0);
			tRead += tm.getTime();
		}
	}

	
};

struct outBufBP
{
	edgeBP *buf;
	int cnt, perBuf;
	FILE *outFile;
	outBufBP() {}
	outBufBP(char *fileName)
	{
		perBuf = bufSize/sizeof(edgeBP);
		buf = (edgeBP*)malloc(sizeof(edgeBP) * perBuf);
		cnt = 0;
		outFile = fopen(fileName, "wb");
	}
	~outBufBP()
	{
		flush();
		fflush(outFile);
		if (outFile != NULL) fclose(outFile);
		free(buf);
	}
	void insert(edgeBP & tmpBP)
	{
		buf[cnt++] = tmpBP;
		if (cnt == perBuf) flush();
	}
	
	void flush()
	{
		timer tm;
		oCnt++;
		fwrite(buf, sizeof(edgeBP), cnt, outFile);
		cnt = 0;
		tWrite += tm.getTime();
	}
	
};








