#include "ioD.h"
#include <vector>
using namespace std;

long long n;

int queryCnt;

char * txtName, * degName, * outName, *inName;

inBufS * labelx, * labely;

inBufS labelin, labelout;
inBufL deg;
edgeL ex, ey;
edgeS sx, sy;

FILE * f1, * f2;

timer tmm;

//int xy[100000][2];

long long insize, outsize;

int query(long long x, long long y)
{
	if (x == y) return 0;

	deg.fseek(x);
	deg.nextOne(ex);
	
	deg.fseek(y);
	deg.nextOne(ey);	
	
	x = ((ex.x<<32)>>32);
	y = ((ey.x<<32)>>32);
		
	if (x > y)
	{
		labelx = &labelout;
		labely = &labelin;
		labelout.fseek(ex.w);
		labelin.fseek(ey.y);
	}
	else
	{
		int xy = x; x = y; y = xy;
		labelx = &labelin;
		labely = &labelout;
		labelin.fseek(ey.y);
		labelout.fseek(ex.w);
	}

	labelx->start();
	labely->start();

	
	
	
	int ans = 10000;
	
	labelx->nextEdge(sx);
	labely->nextEdge(sy);
	
	if (sx.x != -1 && sy.x != -1)
	while (sx.x < y)
	{
		if (sx.x == sy.x) 
		{
			ans = ans>(sx.w + sy.w)?(sx.w + sy.w):ans;
			labelx->nextEdge(sx);
			labely->nextEdge(sy);
			if (sx.x == -1) break;
			if (sy.x == -1) break;
		}
		else if (sx.x < sy.x)
		{
			labelx->nextEdge(sx);
			if (sx.x == -1) break;
		}
		else 
		{
			labely->nextEdge(sy);
			if (sy.x == -1) break;
		}	
	}
	
	while (sx.x != -1 && sx.x < y) 
	{
		labelx->nextEdge(sx);
	}
	if (sx.x == y) ans = ans>sx.w?sx.w:ans;
	
	return ans;
}

int main(int argc, char ** argv)
{
	txtName = argv[1];
	degName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(degName, "%s.deg", txtName);
	
	inName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(inName, "%s.labelin", txtName);
	outName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(outName, "%s.labelout", txtName);

	timer tm;

	n = checkB(degName)/sizeof(edgeL);
	
	deg.init(degName);
	labelin.perBuf = labelout.perBuf = 1000;	
	if (argc > 3) labelin.perBuf = labelout.perBuf = atoi(argv[3]);
	labelin.init(inName);
	labelout.init(outName);
	
	printf("load time %lf (ms)\n", tm.getTime()*1000);

	double sumTime = 0;
	
	queryCnt = 1000;
	if (argc > 2) queryCnt = atoi(argv[2]);
	
	insize = checkB(inName);
	outsize = checkB(outName);

	printf("%lld vertices\n", n);

	srand(time(NULL));

	for (int i = 0; i < queryCnt; i++)
	{		
		int x = rand()%n, y = rand()%n;

		tm.restart();		
		query(x, y);
		sumTime += tm.getTime();
	}
	
	printf("average query time %lf (ms)\n", sumTime*1000/queryCnt);
	
	free(degName);
	free(inName);
	free(outName);
	
	return 0;
}














