

################################### XGBoost classification for model module 1/3/5/6
###############################
library(Matrix)
library(xgboost)
out_func <- function(traindata,testdata,depth_num,eta_num,round_num){
  num <- dim(traindata)[2]
  traindata[,num] <- ifelse(traindata[,num]==-1,0,1)
  testdata[,num] <- ifelse(testdata[,num]==-1,0,1)
  dtrain <- xgb.DMatrix(data=Matrix(data.matrix(traindata[,1:(num-1)]),sparse=T),label=traindata[,num])
  dtest <- xgb.DMatrix(data=Matrix(data.matrix(testdata[,1:(num-1)]),sparse=T),label=testdata[,num])
  
  xgb <- xgboost(data=dtrain,max_depth=depth_num,eta=eta_num,objective='binary:logistic',nround=round_num)
  
  outmat <- c()
  pre_xgb = round(predict(xgb,newdata = dtrain))
  out <- table(traindata[,num],pre_xgb,dnn=c("real","prediction"))
  outmat <- rbind(outmat,c(out[2,2],out[2,1],out[1,2],out[1,1],out[2,2]/sum(out[2,]),out[1,2]/sum(out[1,]),sum(diag(out))/sum(out)))
  
  pre_xgb = round(predict(xgb,newdata = dtest))
  out <- table(testdata[,num],pre_xgb,dnn=c("real","prediction"))
  outmat <- rbind(outmat,c(out[2,2],out[2,1],out[1,2],out[1,1],out[2,2]/sum(out[2,]),out[1,2]/sum(out[1,]),sum(diag(out))/sum(out)))
  
  return(outmat)
}

data_sub_func <- function(data){
  namedel <- c('new_mu','new_coefficient_1','new_coefficient_2','coefficient_1','coefficient_2','coefficient_3','new_model_r2','mu')
  namevect <- colnames(data)
  wheredel <- c()
  for(i in 1:(length(namedel)-2)){a <- which(namevect==namedel[i]);if(length(a)==0){wheredel <- wheredel}else{wheredel <- c(wheredel,a)}}
  if(length(wheredel)==0){data <- data}else{data <- data[,-wheredel]}
  return(data)
} #no new and coef

Out <- c()

depth_num <- 2;eta_num <- 0.74;round_num <- 30 #new sample(5) no new coef
#proposed
traindata = read.csv("./result/proposed/train.csv")[,-1]
testdata = read.csv("./result/proposed/test1.csv")[,-1]
traindata <- data_sub_func(traindata);testdata <- data_sub_func(testdata)
out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
out <- c(out0[1,],out0[2,])
#testdata = read.csv("C:/Users/user/Desktop/classification/sample5/proposed/test2.csv")[,-1]
#testdata <- data_sub_func(testdata)
#out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
#out <- c(out,out0[2,])
#testp <- read.csv("C:/Users/user/Desktop/classification/realdata/1_positive.csv")[,-1]
#testn <- read.csv("C:/Users/user/Desktop/classification/realdata/1_negative.csv")[,-1]
#testdata <- data_sub_func(rbind(testp,testn))
#out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
#out <- c(out,out0[2,])
#Out <- rbind(Out,out)

Out <- out
#methods
for(i in 1:10){
  if(i==100){depth_num <- 2;eta_num <- 0.01;round_num <- 30-20}else{
    depth_num <- 3;eta_num <- 0.58;round_num <- 5 #num_4
  }
  traindata = read.csv(paste0('./result/method',i,'/train.csv'))[,-1]
  testdata = read.csv(paste0('./result/method',i,'/test1.csv'))[,-1]
  traindata <- data_sub_func(traindata);testdata <- data_sub_func(testdata)
  out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
  out <- c(out0[1,],out0[2,])
  # testdata = read.csv(paste0('C:/Users/user/Desktop/classification/sample5/method',i,'/test2.csv'))[,-1]
  # testdata <- data_sub_func(testdata)
  # out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
  # out <- c(out,out0[2,])
  # testp <- read.csv(paste0('C:/Users/user/Desktop/classification/realdata/',i+1,'_positive.csv'))[,-1]
  # testn <- read.csv(paste0('C:/Users/user/Desktop/classification/realdata/',i+1,'_negative.csv'))[,-1]
  # testdata <- data_sub_func(rbind(testp,testn))
  # out0 <- out_func(traindata,testdata,depth_num,eta_num,round_num)
  # out <- c(out,out0[2,])
   Out <- rbind(Out,out)
}
Out  
colnames(Out) <- c("TP","FN","FP","TN","TPR","FPR","ACC","TP","FN","FP","TN","TPR","FPR","ACC")
Out


############################## different thresholds to classification for model module 2/4
########################### the result of table2 and table4
for (model_indx in 1:6){
  model_result <- read.csv(paste0("./result/model",model_indx,"/result.csv"), row.names=1)
  res <- c()
  for (thre in seq(0.05,0.5,0.05)){
    temp <- c()
    for (i in 1:dim(model_result)[1]){
      if(model_result[i,1] > thre){
        temp <- c(temp,1)
      }else{
        temp <- c(temp, -1)
      }
    }
    t=table(temp, model_result[,2])
    temp1 <- cbind(t[2,2],t[1,2],t[2,1],t[1,1])
    colnames(temp1) <- c("TP","FN","FP","TN")
    AC = mean(temp==model_result[,2]) ##AC
    TP = t[2,2]/sum(t[,2]) #TP
    FP = t[2,1]/sum(t[,1]) #FP
    temp2 <- cbind(thre,temp1,AC,TP,FP)
    res <- rbind(res,temp2)
  }
  print(res)
}

