myHHG<-function(x,y,k=99){
   
  library('HHG')
   x<-as.matrix(x)
   y<-as.matrix(y)
   n=dim(x)[1]
   Dx = as.matrix(dist(x), diag = TRUE, upper = TRUE)
   Dy = as.matrix(dist(y), diag = TRUE, upper = TRUE)
   hhg = hhg.test(Dx, Dy, nr.perm = k)
   st=(hhg$sum.chisq)/(hhg$sum.chisq+1)
   st=hhg$sum.chisq/n/(n-1)
   return(list(hhg=st,p.value=hhg$perm.pval.hhg.sc))
}
lmyHHG<-function(i,x,y){
  
  library('HHG')
  x=x[,i]
  x<-as.matrix(x)
  y<-as.matrix(y)
  n=dim(x)[1]
  Dx = as.matrix(dist(x), diag = TRUE, upper = TRUE)
  Dy = as.matrix(dist(y), diag = TRUE, upper = TRUE)
  hhg = hhg.test(Dx, Dy, nr.perm = 0)
  st=(hhg$sum.chisq)/(hhg$sum.chisq+1)
  st=hhg$sum.chisq/n/(n-1)
  return(st)
}
