// This program demostrates how to read the fasta files

#include <iostream.h>                                                                                                                                          

#include "readfile.cpp"


int main()
{ int i, nhuman, nflu;
  DNAdata human,flu;

  // Read the all sequences from the folder called Tanaka
  human.SequenceDirectoryOpen("Tanaka");
  nhuman = human.GetNumSeq();
  cout<<endl<<nhuman<<" sequences read."<<endl;
  cin.get();
  
  // Print the first sequence
  human.print_sequence(0);
  cin.get();

  // Read the all sequences from the fasta file Asia_HA_NA.fas
  // that contains aligned sequences
  flu.SequenceFileOpen("Asia_HA_NA.fas");
  nflu = flu.GetNumSeq();
  cout<<endl<<nflu<<" sequences read."<<endl;
  cin.get();

  // Remove all indels from the aligned sequences and
  // save the restored sequences to the file unaligned.fas
  flu.Unalign();
  flu.Save("unaligned.fas");

  // Add the first sequence in Asia_HA_NA.fas to the data Tanaka
  human.AddSequence(flu.GetSeq(0),"Extra");
  human.print_sequence(nhuman);
  
  
  cin.get();
}
