// This program demonstrate how to build a tree from the sequence files.

#include <time.h>
#include <string.h>

#include "readfile.cpp"
#include "phylotree.cpp"

int main(int argc, char* argv[]){
  int i,k;
  familytree *mytree;
  DNAdata *human, *human_aligned;
  time_t begin, end;

  human = new DNAdata();
  human_aligned = new DNAdata();
  mytree = new familytree();
  
  if( strcmp(argv[1],"d")==0 ) human->SequenceDirectoryOpen(argv[2]);
  if( strcmp(argv[1],"f")==0 ) human->SequenceFileOpen(argv[2]);
  if( argc==5 ){
    human->SequenceFileOpen(argv[3]);           // Insert the CRS for identification of the sites*/
    human->SequenceFileOpen(argv[4]);    // Insert the African L3a sequence for locating the root.
  }
  
  k = human->GetNumSeq();
  cout<<endl<<k<<" sequences read."<<endl;

  mytree->Is_human_mtdna();
  
  begin=time(NULL);
  // Cambridge reference sequence
  mytree->add_tree(human->GetSeq(k-2),k-2);

  // Tanaka 's data
  for(i=0;i<k-2;i++)
    mytree->add_tree(human->GetSeq(i),i);

  // African L3a sequence
  mytree->add_tree(human->GetSeq(k-1),k-1);

  mytree->SetCRS(k-2);              // The sites are labeled according to sequence 0, i.e. the first inputted sequence.
  mytree->SetRoot(k-1);           // The last inputted sequence is used to locate the root.
  mytree->count_all_nodes();  // Count the number of markers on each node.

  mytree->save_tree("FAMAP_tree.txt");                 // Save the tree in Newick format
  mytree->print_tree_to_file("FAMAP_dendrogram.txt");  // Print the dendrogram.

  mytree->SaveAlignedSeq(human_aligned);                            // Output the aligned sequences to a DNAdata structure.
  human_aligned->SaveSiteID("FAMAP_loci.txt",mytree->GetCRSInfo(),1,k-1);     // Print the alignment results with site id.
  human_aligned->Save("FAMAP_Alignment.txt"); 
  end=time(NULL);

  
  printf("\nRunning time = %ld seconds",end-begin);
  cin.get();
  
  delete human;
  delete human_aligned;
  delete mytree;
}

