// In this program, the sequences are inputted according to the order of sequence length.
// The tree is built twice. For the second trial, the sequences are inputted according to the order of parsing the first tree.
// The Robinson Fould distance between the first and second tree is reported.

#include <time.h>
#include <conio.h>

#include "readfile.cpp"
#include "phylotree.cpp"
#include "RFdistance.cpp"
#include "dictionary.cpp"


void add_tree_from_tree(familytree *mytree, phylonode *treenode, DNAdata *human){
  if(treenode==NULL)                              
    return;
  add_tree_from_tree(mytree, treenode->child1,human);
  add_tree_from_tree(mytree, treenode->child2,human);
  if(treenode->seq_id!=-1)
    mytree->add_tree(human->GetSeq(treenode->seq_id),treenode->seq_id);
}

void add_tree_from_avltree(familytree *mytree, AVLnode<Dictionary_word> *treenode, DNAdata *human){
  if(treenode==NULL)                              
    return;
  add_tree_from_avltree(mytree, treenode->child2,human);
  mytree->add_tree(human->GetSeq(treenode->key.y),treenode->key.y);
  add_tree_from_avltree(mytree, treenode->child1,human);
}

int main(){
  AVLtree<Dictionary_word> avltree;
  Dictionary_word key;

  int i,k,stop;
  familytree *mytree, *mytree2, *temptree;
  DNAdata *human;
  time_t begin, end;

  human = new DNAdata();
  mytree = new familytree();
  mytree2 = new familytree();

  human->SequenceDirectoryOpen("Kong");
  human->SequenceFileOpen("african.fasta");    // Insert the African L3a sequence for locating the root.
  human->SequenceFileOpen("CRS.fasta");           // Insert the CRS for identification of the sites*/

  k = human->GetNumSeq();
  cout<<endl<<k<<" sequences read."<<endl;
  cin.get();


  // Sort the sequence using tree sort method. Tree sort is implemented with
  // an AVL tree. See AVLTree.cpp.
  
  for(i=0;i<k-2;i++){
    key.x = human->GetSeq(i);
    key.y = i;
    avltree.insert(key,NULL);
  }

  begin=time(NULL);
  mytree->add_tree(human->GetSeq(k-1),k-1);
  add_tree_from_avltree(mytree, avltree.par_root.child1,human);
  mytree->add_tree(human->GetSeq(k-2),k-2);
  mytree->SetCRS(k-1);
  mytree->SetRoot(k-2);
  mytree->count_all_nodes();  // Count the number of markers on each node.
  end=time(NULL);
  printf("\nRunning time for the first iteration = %ld seconds",end-begin);
  cin.get();

  mytree->print_tree_to_file("human_dendrogram.txt");
  mytree->save_tree("human_tree.txt");

  stop = 0;
  while(!stop){
    begin=time(NULL);

    temptree = mytree;
    mytree = mytree2;
    mytree2 = temptree;

    delete mytree;
    mytree = new familytree();
    add_tree_from_tree(mytree,(mytree2->par_root).child1,human);
    mytree->SetCRS(k-1);
    mytree->SetRoot(k-2);
    mytree->count_all_nodes();  // Count the number of markers on each node.

    end=time(NULL);
    printf("\nRunning time for the second iteration = %ld seconds",end-begin);
    printf("\nRobinson Fould distance = %d\n\nPress '/' to stop or other keys to continue\n",Robinson_Fould(mytree,mytree2));
    if(getch()=='/') stop=1;
  }

  mytree->print_tree_to_file("human_dendrogram2.txt");
  mytree->save_tree("human_tree2.txt");
  
  delete human;
  delete mytree;
  delete mytree2;
}
