#ifndef LAGAN
#define LAGAN

#include "globalalign.cpp"
#include "sparse.cpp"

class LaganAlignment{
  public:
  
  LaganAlignment();
  ~LaganAlignment();
  void LaganAlign(char *input1, char *input2, int n1, int n2, FragmentChain *result);

  private:

  GlobalAlignment *globalalignmachine;
  LocalAlignment *localalignmachine;
  SparseDynamicProgramming *SDPmachine;
};



LaganAlignment::LaganAlignment(){
  globalalignmachine = new GlobalAlignment();
  localalignmachine = new LocalAlignment();
  SDPmachine = new SparseDynamicProgramming();
}

LaganAlignment::~LaganAlignment(){
  delete globalalignmachine;
  delete localalignmachine;
  delete SDPmachine;                                 
}

/*******************************************************
     To implement the restricted dynamic programming
     method of Lagan.
 *******************************************************/

void LaganAlignment::LaganAlign(char *input1, char *input2, int n1, int n2, FragmentChain *result){
  int i,j, sub_n1, sub_n2, aeo, aso, beo, bso, ae, as, be, bs, temp;
  LocalFragmentChain *chain;
  LocalFragmentNode *current;

  chain = new LocalFragmentChain();

  localalignmachine->LocalAlign(input1,input2,n1,n2,chain);
  localalignmachine->Reset();
  SDPmachine->sparse_DP(chain);

  aso=n1;
  bso=n2;
  aeo=n1-1;
  beo=n2-1;

  for(current=chain->sparse_head;current!=NULL;current=current->chain_to){
    as = current->A_start;
    bs = current->B_start;
    ae = current->A_start+current->length-1;
    be = current->B_start+current->length-1;
    
    sub_n1 = aso-ae-1;
    sub_n2 = bso-be-1;
    
    if((sub_n1>0)&&(sub_n2>0)){
      temp = threshold-1;
      globalalignmachine->GlobalAlign(input1+(ae+1)-temp,input2+(be+1)-temp,(sub_n1)+temp,(sub_n2)+temp,result);
      result->insert(BLK,current->length-threshold+1);
    }else if(bs-as > bso-aso){
      result->insert(DEL,(aso-bso)-(ae-be));
      result->insert(BLK,current->length+sub_n2);
    }else if(bs-as < bso-aso){
      result->insert(INS,(bso-aso)-(be-ae));
      result->insert(BLK,current->length+sub_n1);
    }else if((sub_n1==0)&&(sub_n2==0)){
      result->insert(BLK,current->length);
    }
    aso=as;
    bso=bs;
    aeo=ae;
    beo=be;
  }                      

  as=0;
  bs=0;
  if((aso>0)&&(bso>0)){
    globalalignmachine->GlobalAlign(input1,input2,aso,bso,result);
  }else if(bs-as > bso-aso){
    result->insert(DEL,aso-bso);
  }else if(bs-as < bso-aso){
    result->insert(INS,bso-aso);
  }
  
  delete chain;
}




#endif
