% Read the image
dora = imread("dora.png");
% Convert the image to grayscale and normalize it to the range [0, 1]
gray_dora = mean(dora, 3) / 255;
[h, w] = size(gray_dora);

% Construct the Haar matrix
H = zeros(h, w);
H(1, :) = 1;
H(2, 1:end/2) = 1;
H(2, end/2+1:end) = -1;
for i = 3:h
    for j = 1:w
        p = floor(log2(i-1));
        n = (i-1) - 2^p;
        t = (j-1)/w;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Complete the code below, replace the %???? by the conditions
        if %????
            H(i, j) = sqrt(2)^p;
        elseif %????
            H(i, j) = -sqrt(2)^p;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        end
    end
end
figure; imshow((H+1)/2); title('Haar function'); 
H = H/sqrt(h);
Ht = H';

% Compute the Haar coefficients and reconstruct the image from the
% coefficients.
G = H * gray_dora * Ht;
recon = Ht * G * H;
figure; imshow(recon); title('Reconstructed image'); 

% Generate the approximation of the image using only the coefficients
% in the upper left corner.
img = zeros(h, w);
for i = 1:h/8
    for j = 1:w/8
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Complete the code below. This one should be similar to that of Q3, the difference is that G is not a diagonal matrix.
        img = img + %????;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
end
figure; imshow(img); title('The approximation'); 
