% Read the image
dora = imread("dora.png");
% Convert the image to grayscale and normalize it to the range [0, 1]
gray_dora = mean(dora, 3) / 255;
[h, w] = size(gray_dora);

% Extend the image periodically
padded_dora = [[gray_dora, gray_dora, gray_dora
                 gray_dora, gray_dora, gray_dora
                 gray_dora, gray_dora, gray_dora]];
padded_dora = padded_dora(h:2*h+1, w:2*w+1);

% Define the convolution kernel. 
kernel = [[0, -1, 0
           -1, 4, -1
           0, -1, 0]];

conv1_dora = zeros(h, w);
for i = 1:h
    for j = 1:w
        conv1_dora(i, j) = sum(padded_dora(i:i+2, j:j+2) .* kernel, 'all');
    end
end

figure; imshow(conv1_dora); title('Conv with kernel');

% Convert the image to a vector
vec_dora = reshape(gray_dora, [h*w, 1]);

% In the following, we implement the same algorithm with the big matrix H.
% Create an array 'ijv' to store the indices and values of the big matrix H.
ijv = zeros(h*w*3*3, 3); % cols: row, column, value
ind = 1;
for alpha = 1:h
    for beta = 1:w
        for i = -1:1
            x = alpha + i;
            for j = -1:1
                y = beta + j;
                
                % handle the indices outside the image domain.
                if alpha == 1 && i == -1
                    x = h;
                elseif alpha == h && i == 1
                    x = 1;
                end
            
                if beta == 1 && j == -1
                    y = w;
                elseif beta == w && j == 1
                    y = 1;
                end
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                % Complete the code below
                ijv(ind, :) = ; % [????, ????, ????];
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                ind = ind + 1;
                
            end
        end
    end
end

% Since the matrix H is too big, we create it as a sparse matrix.
H = sparse(ijv(:, 1), ijv(:, 2), ijv(:, 3), h*w, h*w);

vec_conv_dora = H * vec_dora;
conv2_dora = reshape(vec_conv_dora, [h, w]);

figure; imshow(conv2_dora); title('Conv with the big matrix H');
                
% Compute the error of the two output images. This value should be very
% small.
err = sum(abs(conv1_dora - conv2_dora), 'all')

