%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MATH3360 Tutorial 3 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
% Resize the image for better processing
img1 = imresize(imread('img1.jpg'), [1024, 1024]);

figure;
montage({img1}, 'size', [1, 1]);

img1 = double(rgb2gray(img1));
[H, W] = size(img1);

%%
% Haar Matrix
disp(HaarMatrix(4));

%%
% Haar Transform
transformed = HaarMatrix(H) * img1 * HaarMatrix(W)';
restored = HaarMatrix(H)' * transformed * HaarMatrix(W);

figure;
imshow(uint8(restored));

%%
% Originally, there are 1024 * 1024 values in 
% the transformed matrix.
% Now, I truncate it to n_row * n_col values.
% Compression rario = (n_row * n_col) / (1024 ^ 2)
n_row = 128;
n_col = 128;

truncate = transformed;
truncate(:, (n_col+1):W) = 0;
truncate((n_row+1):H, :) = 0;

compressed = HaarMatrix(H)' * truncate * HaarMatrix(W);

figure;
montage({uint8(img1), uint8(compressed)}, 'size', [1, 2]);


%%
% Functions used to define Haar Matrix

function H = HaarMatrix(N)
    H = zeros(N, N);
    for i = 1:N
        for j = 1:N
            H(i, j) = HaarFunction((i-1), (j-1)/N);
        end
    end
    H = H / sqrt(N);
end

function h = HaarFunction(k, x)
    if k == 0
        h = 1;
    else
        p = floor(log2(k));
        n = k - 2^p;
        if (n / 2^p <= x) && (x < (n + .5) / 2^p)
            h = sqrt(2) ^ p;
        elseif ((n + .5) / 2^p <= x) && (x < (n + 1) / 2^p)
            h = -sqrt(2) ^ p;
        else
            h = 0;
        end
    end
end


%%

