source('HHG-SIS.R')
source('examples.R')
source('model.R')

Args <- commandArgs(trailingOnly=TRUE)
typ=as.integer(Args[1]) ### model number, 1-16.
n=as.integer(Args[2]) #### sample size

methods=c('SIS','NIS','DC','RRCS','MC','HHG')
mtype=types

infor=paste('Model=',types[typ],', n=',n,sep='')
cat('Simulation information:',infor,'\n')

k=500

fold=paste('./n=',n,'/',sep='')

if(!dir.exists(fold)){
  dir.create(fold)
}

file=paste(fold,'model',typ,'.Rdata',sep='')
cat('Result file:',file,'\n')

statV <- array(0,dim=c(k,6,1000))
for(i in 1:k)
{
  cat('i=',i,'\n')
  set.seed(i)
  rlst=aexamples(types[typ],n)
  X=rlst$X
  Y=rlst$Y
  for(im in 1:6)
  {
    res=SISs(X,Y,methods[im])
    #morder=res$order
    #msize[i,im]=minisize(morder,tmodel[[mtype[typ]]])
    values=res$values
    statV[i,im,]=values
  }
}
save(statV,n,file=file)
