## simulation of IS-HHG
source('myHHG.R')
require(splines)
example1a <- function(p,n,s)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:950){
    X[,i]=rnorm(n)
  }
  for(i in 951:p)
  {
    for(j in 1:s)
    {
      X[,i]=X[,i]+X[,j]*(-1)^{j+1}/5
    }
    X[,i]=X[,i]+sqrt(abs(1-s*rnorm(n)/25))
  }
  Y=0
  for(j in 1:s)
    Y=Y+(-1)^{j+1}*X[,j]
  
  return(list(X=X,Y=Y))
}
example1b <- function(p,n)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p){
    X[,i]=rnorm(n)
  }
  X[,2]=X[,1]^3/3+rnorm(1)
  Y=X[,1]+X[,2]+X[,3]
  return(list(X=X,Y=Y))
}
example4a <-function(p,n,normal=T)
{
   X <- array(0,dim=c(n,p))
   for(i in 1:p)
   {
     if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
   }
   Y=X[,1]*X[,2]+X[,3]*X[,4]
   return(list(X=X,Y=Y))
}
example4b <-function(p,n,normal=T)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p)
  {
    if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
  }
  Y=X[,1]^3+X[,2]^3+X[,3]^2*X[,4]
  return(list(X=X,Y=Y))
}
example4c <-function(p,n,normal=T)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p)
  {
    if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
  }
  Y=sin(X[,1])*X[,2]+X[,1]*sin(X[,2])
  return(list(X=X,Y=Y))
}
example4d <-function(p,n,normal=T)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p)
  {
    if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
  }
  Y=X[,1]*exp(X[,2])
  return(list(X=X,Y=Y))
}
example4e <-function(p,n,normal=T)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p)
  {
    if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
  }
  Y=X[,1]*log(abs(X[,2]+0.0001))
  return(list(X=X,Y=Y))
}
example4f <-function(p,n,normal=T)
{
  X <- array(0,dim=c(n,p))
  for(i in 1:p)
  {
    if(normal) X[,i]=rnorm(n) else X[,i]=rcauchy(n)
  }
  Y=X[,1]/(0.0001+X[,2])
  return(list(X=X,Y=Y))
}
aexamples <- function(type,n)
{
  p=1000
  rslt=switch(type,
              '1a'=example1a(p,n,3),
              '1b'=example1a(p,n,6),
              '1c'=example1a(p,n,12),
              '1d'=example1b(p,n),
              '2a'=example4a(p,n,T),
              '2b'=example4b(p,n,T),
              '2c'=example4c(p,n,T),
              '2d'=example4d(p,n,T),
              '2e'=example4e(p,n,T),
              '2f'=example4f(p,n,T),
              '3a'=example4a(p,n,F),
              '3b'=example4b(p,n,F),
              '3c'=example4c(p,n,F),
              '3d'=example4d(p,n,F),
              '3e'=example4e(p,n,F),
              '3f'=example4f(p,n,F))
  num=substr(type,1,1)
  num=as.integer(num)
  Y=rslt$Y
  if(num==1) rslt$Y=Y+rnorm(n,sd = sqrt(3))
  if(num==2) rslt$Y=Y+rnorm(n)
  return(rslt)
}
