
Args <- commandArgs(trailingOnly=TRUE)
n=as.integer(Args[1])

task_name=paste('Z-',n,sep='')
main_char=paste('Z-',n,sep='')
ntask=16

for(state in 14:14)
{  
  qsub_file=paste(task_name,state,'.txt',sep='') 
  jobname=paste(main_char,state,sep='')   
  logname=paste(main_char,state,'.log',sep='') 
  errfile=paste(main_char,state,'.err',sep='') 
  
  sink(qsub_file)
  cat('#!/bin/bash\n')
  cat('\n')
  cat(sprintf("#PBS -N %s\n",jobname))
  cat('\n')
  cat('#PBS -q batch\n') ### batch,bigmem,fast(24 hours).
  cat('\n')
  cat(sprintf("#PBS -o %s\n",logname))
  cat('\n')
  cat(sprintf("#PBS -e %s\n",errfile))
  cat('\n')
  cat('#PBS -m bea')
  cat('\n')
  dir<-getwd()
  cat(paste('cd',dir,'\n'))
  
  out=paste(task_name,state,sep='')
  cat(sprintf("R CMD BATCH --vanilla '--args %d %d' simulation.R %s.Rout",
              state,n,out))
  
  sink()
  com=paste('qsub',qsub_file)
  system(com) 
}

  



