// This program demonstrate how to do sparse dynamic programming
// to chain the fragments obtained from local alignment.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sparse.cpp"


int main(){
  LocalFragmentChain *chain;
  LocalAlignment *alignmachine;
  SparseDynamicProgramming *SDPmachine;
  char in1[50],in2[50];

  // The LocalFragmentChain object is for storing the output of local alignment
  chain = new LocalFragmentChain();
  alignmachine = new LocalAlignment();
  SDPmachine = new SparseDynamicProgramming();
  
  threshold = 8;
//             0000000000111111111122222222
//             0123456789012345678901234567
  strcpy(in1, "TCGCATCTGCAGAAGCATCTGCAGAA");
  strcpy(in2, "GCATCTGCAGAATCTCGCATCTGCAGAA");
  alignmachine->LocalAlign(in1,in2,strlen(in1),strlen(in2),chain);
  SDPmachine->sparse_DP(chain);

  printf("Local alignment results\n\n");
  chain->print(LOCAL);
  printf("\n\nSparse dynamic programming results\n\n");
  chain->print(SPARSE);

  delete chain;
  delete alignmachine;
  delete SDPmachine;

  printf("\n\nEnd of the program\n");
  cin.get();
}

