/*******************************************************

    This program demonstrate how to obtain the local alignment fragments.

    The results of local alignment are represented
    as a chain of fragments arranged in the
    ascending order of B_start, then
    descending order of A_start.
    
    Example:
    
            0000000000111111111122222222
            0123456789012345678901234567
    Seq A = TCGCATCTGCAGAAGCATCTGCAGAA
    Seq B = GCATCTGCAGAATCTCGCATCTGCAGAA
    
    The chain of fragments is
    
    (14,0,12)->(2,0,12)->(0,14,14)->(14,16,12)

 *******************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "localalign.cpp"


int main(){
  LocalFragmentChain *chain;
  LocalAlignment *alignmachine;
  char in1[50],in2[50];

  // The LocalFragmentChain object is for storing the output of local alignment
  chain = new LocalFragmentChain();
  alignmachine = new LocalAlignment();
  
  threshold = 8;
//             0000000000111111111122222222
//             0123456789012345678901234567
  strcpy(in1, "TCGCATCTGCAGAAGCATCTGCAGAA");
  strcpy(in2, "GCATCTGCAGAATCTCGCATCTGCAGAA");
  alignmachine->LocalAlign(in1,in2,strlen(in1),strlen(in2),chain);

  chain->print(LOCAL);

  delete chain;
  delete alignmachine;

  printf("End of the program\n");
  cin.get();
}

