/*******************************************************

    This program demonstrate how to do global alignment using Needleman and Wunsch's algorithm.

    Global pairwise alignment using dynamic programming approach
    The algorithm of Needleman and Wunsch is used

    The results of global alignment are represented
    as a chain of fragments.
    
    Example:
    
    Seq A = GCATCTGCAGAATCTC
    Seq B = GCAACT ATGGCTGAC
    
    The result is represented as
    
    (BLK 3) -> (POI 1) -> (BLK 2) -> (DEL 1) ->
    (POI 2) -> (BLK 1) -> (POI 2) -> (BLK 1) ->
    (POI 2) -> (BLK 1)
      
 *******************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globalalign.cpp"


int main(){
  FragmentChain *chain;
  GlobalAlignment *alignmachine;
  char in1[50],in2[50];

  // The FragmentChain object is for storing the output of global alignment
  chain = new FragmentChain();
  alignmachine = new GlobalAlignment();
  
  strcpy(in2, "AGCTAGAGACCAGTCTGAGGTAGA");
  strcpy(in1, "AGCTAGAGACCAGCTATCTAGAGGTAGA");
  alignmachine->GlobalAlign(in1,in2,strlen(in1),strlen(in2),chain);

  chain->print();

  delete chain;
  delete alignmachine;

  printf("End of the program\n");
  cin.get();
}

