#include <iostream.h>                                                                                                                                          
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <time.h>

#include "readfile.cpp"
#include "phylotree.cpp"
#include "simtree.cpp"
#include "RFdistance.cpp"


// This program demonstrate how to simulate tree topology and mutations.

void SimulateOneTree()
{ familytree *mytree;
  tree_generator *sim;
  DNAdata *human, *human_aligned;

  srand(456);

  human = new DNAdata();
  human_aligned = new DNAdata();
  mytree = new familytree();
  sim = new tree_generator();

  human->SequenceFileOpen("african.fasta");
  human->Unalign();
  cout<<endl<<human->GetNumSeq()<<" sequences read."<<endl;

  // Simulate the phylogeny using Kingman's coalescence theory.
  // Then, simulate the mutations on the tree. The inputted sequence is the common ancestor of all generated sequences.
  sim->sim_tree(mytree,10,human->GetSeq(0));      
  
  mytree->SetCRS(0);

  mytree->count_all_nodes();  // Count the number of markers on each node.

  mytree->save_tree("simulated_tree.txt");                 // Save the tree in Newick format
  mytree->print_tree_to_file("simulated_dendrogram.txt");  // Print the dendrogram.

  mytree->SaveAlignedSeq(human_aligned);                            // Output the aligned sequences to a DNAdata structure.
  human_aligned->SaveSiteID("loci.txt",mytree->GetCRSInfo(),0,9);     // Print the alignment results with site id.
  
  cout<<"\nEnd of the program\n";
  cin.get();
  
  delete human;
  delete human_aligned;
  delete mytree;
  delete sim;
}

// This program demonstrate how to load a tree topology file and simulate the mutations on the loaded topology.

void SimulateOneTreeFromTopology()
{ familytree *mytree;
  tree_generator *sim;
  DNAdata *human, *human_aligned;
  FILE *fp;
  char string[MAXL];

  srand(456);

  human = new DNAdata();
  human_aligned = new DNAdata();
  mytree = new familytree();
  sim = new tree_generator();

  human->SequenceFileOpen("african.fasta");
  human->Unalign();
  cout<<endl<<human->GetNumSeq()<<" sequences read."<<endl;

  // Load the topology from a file.
  fp = fopen("fould_trees.txt","r");
  string[0]='\0';
  mytree->load_topology(fp,string);
  fclose(fp);

  sim->sim_tree_from_topology(mytree,human->GetSeq(0));      // Simulate the mutations on the tree. The inputted sequence is the common ancestor of all generated sequences.
  
  mytree->SetCRS(0);

  mytree->count_all_nodes();  // Count the number of markers on each node.

  mytree->save_tree("simulated_tree.txt");                 // Save the tree in Newick format
  mytree->print_tree_to_file("simulated_dendrogram.txt");  // Print the dendrogram.

  mytree->SaveAlignedSeq(human_aligned);                            // Output the aligned sequences to a DNAdata structure.
  human_aligned->SaveSiteID("loci.txt",mytree->GetCRSInfo(),0,mytree->GetNumSeq()-1);     // Print the alignment results with site id.
  
  cout<<"\nEnd of the program\n";
  cin.get();
  
  delete human;
  delete human_aligned;
  delete mytree;
  delete sim;
}

// This program demonstrate how to do repeated tree simulations.

void SimulateManyTree()
{ int i,k;
  familytree *mytree, *newtree;
  DNAdata *human_root, *human_simulated;
  int n_species = 10;
  int nrep =10;
  time_t begin, end;
  FILE *fp;
  tree_generator *sim;

  srand(456);

  human_root = new DNAdata();

  human_root->SequenceFileOpen("african.fasta");
  human_root->Unalign();

  fp = fopen("output.txt","w");
  begin=time(NULL);
  for(k=0;k<nrep;k++){
    human_simulated = new DNAdata();
    mytree = new familytree();
    newtree = new familytree();
    sim = new tree_generator();

    // Simulate the phylogeny using Kingman's coalescence theory.
    // Then, simulate the mutations on the tree. The inputted sequence is the common ancestor of all generated sequences.
    sim->sim_tree(mytree,n_species,human_root->GetSeq(0));      

    mytree->SetCRS(0);
    mytree->count_all_nodes();  // Count the number of markers on each node.
    mytree->save_tree("simulated_tree.txt");                 // Save the tree in Newick format
    mytree->print_tree_to_file("simulated_dendrogram.txt");  // Print the dendrogram.

    mytree->SaveAlignedSeq(human_simulated);    // Output the aligned sequences to a DNAdata structure.
    human_simulated->Unalign();                 // Unalign the sequences

    for(i=0;i<n_species;i++)
      newtree->add_tree(human_simulated->GetSeq(i),i);
    newtree->SetCRS(0);
    newtree->count_all_nodes();  // Count the number of markers on each node.
    newtree->save_tree("simulated_tree2.txt");                 // Save the tree in Newick format
    newtree->print_tree_to_file("simulated_dendrogram2.txt");  // Print the dendrogram.

    printf("\n%d simulations done.\n",k+1);
    fprintf(fp,"%d\n",Robinson_Fould(mytree,newtree));
    
    delete human_simulated;
    delete mytree;
    delete newtree;
    delete sim;
  }
  end=time(NULL);
  fclose(fp);
  
  printf("\nRunning time = %ld seconds",end-begin);
  cin.get();

  delete human_root;
}


int main(){
  int m = 2;
  
  switch(m){
    case 0: SimulateOneTree(); break;
    case 1: SimulateOneTreeFromTopology(); break;
    case 2: SimulateManyTree(); break;
  }
  return 0;
}

