// This program demonstrate how to load the tree from a file
// and add new sequences to the tree.

#include <time.h>

#include "readfile.cpp"
#include "phylotree.cpp"

void Build_Save(){
  int i,k;
  familytree *mytree;
  DNAdata *human;
  time_t begin, end;

  human = new DNAdata();
  mytree = new familytree();

  human->SequenceFileOpen("Kong.fas");
  human->SequenceFileOpen("CRS.fasta");           // Insert the CRS for identification of the sites*/

  k = human->GetNumSeq();
  cout<<endl<<k<<" sequences read."<<endl;

  mytree->Is_human_mtdna();
  
  begin=time(NULL);
  // Cambridge reference sequence
  mytree->add_tree(human->GetSeq(k-1),0);

  // Kong's data
  for(i=0;i<k-1;i++)
    mytree->add_tree(human->GetSeq(i),1+i);

  mytree->count_all_nodes();  // Count the number of markers on each node.
  mytree->save_tree("human_tree.txt");                 // Save the tree in Newick format

  mytree->SetCRS(0);              // The sites are labeled according to sequence 0, i.e. the first inputted sequence.
  mytree->count_all_nodes();  // Count the number of markers on each node.
  mytree->print_tree_to_file("human_dendrogram.txt");  // Print the dendrogram.

  end=time(NULL);

  printf("\nRunning time = %ld seconds",end-begin);
  cin.get();

  delete human;
  delete mytree;
}

void Load_Add(){
  int i,k,offset;
  familytree *mytree;
  DNAdata *human;
  time_t begin, end;

  human = new DNAdata();
  mytree = new familytree();

  // Load the existing tree.
  mytree->Is_human_mtdna();
  mytree->load_tree("human_tree.txt");
  offset = mytree->GetNumSeq();

  // Read new sequences
  human->SequenceFileOpen("Tanaka.fas");
  human->SequenceFileOpen("african.fasta");    // Insert the African L3a sequence for locating the root.
  k = human->GetNumSeq();
  cout<<endl<<k<<" sequences read."<<endl;

  begin=time(NULL);

  // Input Tanaka's sequences to the existing tree.
  for(i=0;i<50;i++)
    mytree->add_tree(human->GetSeq(i),i+offset);

  // African L3a sequence
  mytree->add_tree(human->GetSeq(k-1),50+offset);

  mytree->SetCRS(0);                               // The sites are labeled according to sequence 0, i.e. the first inputted sequence.
  mytree->SetRoot(50+offset);          // The last inputted sequence is used to locate the root.
  mytree->count_all_nodes();  // Count the number of markers on each node.

  mytree->save_tree("human_tree2.txt");                 // Save the tree in Newick format
  mytree->print_tree_to_file("human_dendrogram2.txt");  // Print the dendrogram.

  end=time(NULL);

  printf("\nRunning time = %ld seconds",end-begin);
  cin.get();

  delete human;
  delete mytree;
}

int main(){
  Build_Save();
  Load_Add();
}
