// This program demonstrate how to find Robinson Fould distance.

#include <time.h>

#include "readfile.cpp"
#include "phylotree.cpp"
#include "RFdistance.cpp"

int main(){
  int i,j;
  familytree **mytree;
  char *str;
  FILE *fp;

  str = (char *)malloc((unsigned) MAXL*sizeof(char));
  mytree = (familytree **)malloc((unsigned) 5*sizeof(familytree*));
  str[0]='\0';
  fp = fopen("fould_trees.txt","r");
  for(i=0;i<5;i++){
    mytree[i] = new familytree();
    mytree[i]->load_topology(fp,str);
    cout<<"Pass\n";
  }
  fclose(fp);

  printf("Distance matrix:\n");
  for(i=1;i<=4;i++){
    for(j=0;j<=i-1;j++)
      printf("%d ",Robinson_Fould(mytree[i],mytree[j]));
    printf("\n");
  }

  for(i=0;i<5;i++)
    delete mytree[i];
  free(mytree);
  free(str);
  
  cout<<"\nEnd of the program\n"; cin.get();
}
