// This program demonstrate how to do sorting using AVL tree

#include "AVLTree.cpp"

#define nData 15

int main(){
  AVLtree<double> avltree;

  int i;
  
  // The data for sorting
  double val[nData]={51.5,83,3,62,13,43,98,64,32,78,23,75,81,34,47};

  // Add all data to the AVL tree
  for(i=0;i<nData;i++)
    avltree.insert(val[i],NULL);

  // Print the AVL tree and the sorted data
  avltree.print();
  cout<<"\n\n";
  avltree.print_sorted_list();
  cout<<"\n\n";

  // Remove the smallest value that is >= 64.0
  avltree.remove( avltree.search(64.0,GE) );

  // Print the updated AVL tree and the updated sorted data
  avltree.print();
  cout<<"\n\n";
  avltree.print_sorted_list();
  cout<<"\n\n";
  
  cin.get();
}

