#ifndef PHYLONODE
#define PHYLONODE


/*******************************************************
         Marker -- The loci where mutation occurs
 *******************************************************/

class marker{
  public:
  
  int loci;
  char ch_parent,ch_child;
  marker *m_pNext;
  
  public:

  marker(int aloci, char ach_parent, char ach_child, marker *am_pNext);
  void swap();
};

marker::marker(int aloci, char ach_parent, char ach_child, marker *am_pNext){
  loci=aloci;
  ch_parent=ach_parent;
  ch_child=ach_child;
  m_pNext=am_pNext;
}

void marker::swap(){
  char temp;
  temp = ch_parent;
  ch_parent = ch_child;
  ch_child = temp;
}



/*******************************************************
        Phylonode -- The node on a phylogeny
        "markers" is used to record the discrepancies
          (mutations) with the parent
 *******************************************************/

class phylonode{
  public:
  
  // Basic information
  int seq_id;
  int n_markers;
  phylonode *parent, *child1, *child2;
  marker *markers;

  // Used in constructing phylogeny
  int avalue, bvalue, ivalue, ivalue2;

  // Used in calculating Robinson Fould distance
  int height, bCleared;
  phylonode *match_with;

  // Used in tree simulation
  double coalescent_time;

  public:
  
  phylonode(){};
  phylonode(int id);
  ~phylonode();
  void SetNode(int id);
  void free_markers();
  void swap_markers();
};

phylonode::phylonode(int id){
  SetNode(id);
}

phylonode::~phylonode(){
  free_markers();
  delete markers;
}

void phylonode::SetNode(int id){
  seq_id=id;
  parent=NULL;
  child1=NULL;
  child2=NULL;
  markers=new marker(-1,'\0','\0',NULL);
}

void phylonode::free_markers(){
  marker *current, *temp;
  for(current = markers->m_pNext;current!=NULL;){
    temp=current;
    current=current->m_pNext;
    delete temp;
  }
  markers->m_pNext = NULL;
}

void phylonode::swap_markers(){
  marker *current;
  for(current=markers->m_pNext;current!=NULL;){
    current->swap();
    current=current->m_pNext;
  }
}


#endif
