% Read the image
dora = imread("dora.png");
% Convert the image to grayscale and normalize it to the range [0, 1]
gray_dora = mean(dora, 3) / 255;
[H, W] = size(gray_dora);

% Here we use matrix multiplication to implement convolution with the
% kernel (1/9) * [[1 1 1
%                  1 1 1
%                  1 1 1]]
hr_1 = eye(H);
hr_2 = circshift(hr_1, [1 0]);
hr_3 = circshift(hr_1, [-1 0]);
hr = (hr_1 + hr_2 + hr_3) / 3;
hc = hr';
blur_dora = hc * gray_dora * hr;
figure
subplot(1,2,1), imshow(gray_dora); title('Original image');
subplot(1,2,2), imshow(blur_dora); title('Blurred image');

% Complete the following codes to implement convolution with the
% kernel (1/16) * [[1 2 1
%                  2 4 2
%                  1 2 1]]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Complete the code below
% Hint: Similar to the above code.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
hc = hr';
blur_dora = hc * gray_dora * hr;
figure
subplot(1,2,1), imshow(gray_dora); title('Original image');
subplot(1,2,2), imshow(blur_dora); title('Blurred image');





