%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MATH3360 Tutorial 1 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

% basic reading and writing, displaying
% basic transformation

% Reminder: 
% Please Install Image Processing ToolBox

%% Reading Images
img1 = imread('img1.jpg');
img2 = imread('img2.jpg');

%% Displaying 1 Image
figure;
imshow(img1);
% imshow(img2);

%% Displaying Multiple Images
figure;
montage({img1, img2}, 'size', [1, 2]);

%% RGB channel of the image
img = img1;
img_r = img;
img_g = img; 
img_b = img;

img_r(:, :, [2, 3]) = 0;
img_g(:, :, [1, 3]) = 0;
img_b(:, :, [1, 2]) = 0;

figure;
montage({img, img_r, img_g, img_b}, 'size', [2, 2]);

%% Some Transformations
% Since image are stored in matrix form, any
% operation to matrix can be applied to image.
img = img1;

% Reducing r and b to half
img_1 = img;
img_1(:, :, 3) = img(:, :, 3);
img_1(:, :, [1, 2]) = img(:, :, [1, 2]) * .5;

% flip along 1st axis (x-axis)
% flip vertically
img_2 = flip(img, 1);

% flip along 2nd axis (y-axis)
% flip horizontally
img_3 = flip(img, 2);

% flip along 3rd axis (rgb)
% this means r <-> b, g stay the same
img_4 = flip(img, 3);

figure;
montage({img_1, img_2, img_3, img_4}, 'size', [2, 2]);

%% Exporting Image
img = img1;
img_4 = flip(img, 3);
imwrite(img_4, 'img3.png');


