% Read the image 
I = imread('image.png');
% Convert the image to grayscale and normalize into [0, 1]
I = double(im2gray(I)) / 255;

% Display original image
figure;
subplot(2, 2, 1);
imshow(I);
title('Original Image');
axis off;

% SVD
[U,S,V] = svd(I);


k_values = [5, 10, 50];

for i = 1:length(k_values)
    k = k_values(i);
    % Drop singular value after `k`
    S_k = S;
    S_k(k:end,k:end) = 0;
    % Reconstruct
    I_k = U*S_k*V';

    % Display
    subplot(2, 2, i + 1);
    imshow(I_k);
    title(['Reconstructed Image (k=', num2str(k), ')']);
    axis off;
    
end

% Save image
% saveas(gcf, 'result.png')