function J=imcontrast(varargin)
if nargin==1&iscell(varargin{1})
    varargin=varargin{1};
end
[M,N]=size(varargin{1});
p=0.99;

if length(varargin)==1
    I=varargin{1};
    n=find(~isnan(I));
    [I0,j0]=significant(I(n),p);
    a=min(I(n(j0)));
    b=max(I(n(j0)));
    if b==a
        b=min(I(find(I>a)));
        if isempty(b)
            b=a+1;
            warning('Image is constant!')
        end
    end
    J=255/(b-a)*(I-a);
else
    I=reshape(cell2mat(varargin),M,N*length(varargin));
    n=find(~isnan(I));
    [I0,j0]=significant(I(n),p);
    a=min(I(n(j0)));
    b=max(I(n(j0)));
    if b==a
        b=min(I(find(I>a)));
        if isempty(b)
            b=a+1;
            warning('Images are constant!')
        end
    end
    J=255/(b-a)*(I-a);
    J=mat2cell(J,M,N*ones(1,length(varargin)));
end
        

function [x,j]=significant(x,p)
jnan=find(~isnan(x));
if ~isreal(x)
    x0=abs(x-(median(real(x(jnan)))+i*median(imag(x(jnan)))));
else
    x0=x;
end
N=length(x0(:));
K=round(p*N);

x1=sort(x0(:));
a=1:(N-K+1);
[~,j]=min(x1(a+K-1)-x1(a));

a0=a(j(1));
a1=a0+K-1;
j=find(x0>=x1(a0)&x0<=x1(a1));
x(setdiff(1:length(x(:)),j))=NaN;


