function aux_interferogram_Fouier_visual(In,rho,w,visualFactor,flagZero)
%This program plots the boundaries of the twin and zeroth orders of the 
% interferogram in the Foruier domain.
% INPUT:
%      In          -- interferogram;
%      w           -- 1x2, reference wave frequency (wx,wy);
%      rho         -- circular-shaped bandwidth radius of the object wave, e.g., sqrt(2*pi)/2;
%      visualFactor-- intensity scale (a constant value) for visulization
%      flagZero    -- true or false, indicate whether show the boundary of the 0th order or not.
%
% AUTHOR : Gang Luo and Thierry Blu
% DATE   : November 2022
% CONTACT: Gang Luo (luogang@link.cuhk.edu.hk), The Chinese University of Hong Kong.

%display figure of Fourier of interferogram
[M,N] = size(In);
ky0_num = w(2)./(2*pi/N);
kx0_num = w(1)./(2*pi/M);
rho_FT = rho./(2*pi/M);
img_FT  = @(img)(fftshift(fft2((img))));In_FT_amp = abs(img_FT(In));

figure,
imview(visualFactor*imcontrast(In_FT_amp));hold on;
[x_circ_pos,y_circ_pos] = circle_fun(N/2+1+ky0_num,M/2+1+kx0_num,rho_FT);plot(x_circ_pos,y_circ_pos,'y--','LineWidth',3);hold on;
[x_circ_pos,y_circ_pos] = circle_fun(N/2+1-ky0_num,M/2+1-kx0_num,rho_FT);plot(x_circ_pos,y_circ_pos,'y--','LineWidth',3);hold on;
set(gcf,'Position',[800,400,500,500]);

if ~exist('flagZero','var') 
    flagZero = false(1);
end
if flagZero
    [x_circ_pos,y_circ_pos] = circle_fun(N/2+1,M/2+1,2*rho_FT);plot(x_circ_pos,y_circ_pos,'y--','LineWidth',3);
end
set(gca,'position',[0,0,1,1]);
drawnow;

end

 function [x_circ_pos,y_circ_pos] = circle_fun(xc,yc,rho)
    theta = 0:pi/50:2*pi;
    x_circ_pos = rho * cos(theta) + xc;
    y_circ_pos = rho * sin(theta) + yc;
 end