function [b0,w0]=wextract2D(w,band)
%WEXTRACT2D Extraction of wavelet bands.
% 	band=wextract2D(w,bandnumber) extracts the band #   
% 	'bandnumber' of a 2D wavelet transform.
% 
% 	Input:
% 	w = image of wavelet coefficients
% 	bandnumber =    'LH1' or 'HH1' or 'HL1' at iteration depth 1
%                   'LH2' or 'HH2' or 'HL2' at iteration depth 2
%                   etc.
% 	
% 	Output:
% 	band=wav{bandnumber}
%	w=wavelet transform keeping only this band

M0=length(w);
if M0~=2^round(log(M0)/log(2))
	disp(' ')
	disp('The size of the input signal must be a power of two!')
	disp(' ')
	band=[];
	return
end

if band(1:2)=='LL'
    M=M0/2^str2num(band(3:end));
	w0=w(1:2*M,1:2*M);
    n=1:M;
    b0=w0(n,n);
	w0=zeros(M0,M0);
	w0(n,n)=b0;
else
    M=M0/2^str2num(band(3:end));
    w0=w(1:2*M,1:2*M);
    n=1:M;

    switch band(1:2)
    case 'HL'
        b0=w0(M+n,n);
        w0=zeros(M0,M0);
        w0(M+n,n)=b0;
    case 'HH'
        b0=w(M+n,M+n);
        w0=zeros(M0,M0);
        w0(M+n,M+n)=b0;
    case 'LH'
        b0=w(n,M+n);
        w0=zeros(M0,M0);
        w0(n,M+n)=b0;
    end
end

