function waveletplot2D(w,Niterations,show)
% waveletplot2D(w,Niterations)
w=waveletrescale(w,Niterations);

image(w)
colormap(gray(256))
axis image
axis off
if nargin<3
    waveletgrid(length(w),Niterations)
else
    waveletgrid(length(w),Niterations,show)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% EMBEDDED FUNCTIONS %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%

function waveletgrid(M,Niterations,show)
if nargin<3
    show=0;
end
hold on
for j=1:Niterations
	plot([M/2 M/2]+0.5,[0.5 M+0.5],'y')
	plot([0.5 M+0.5],[M/2 M/2]+0.5,'y')
    if show&j<=3
        text(M,M/2,['LH' num2str(j)],'color',[1 1 0],'horizontalalignment','right','verticalalignment','bottom')
        text(M,M,['HH' num2str(j)],'color',[1 1 0],'horizontalalignment','right','verticalalignment','bottom')
        text(M/2,M,['HL' num2str(j)],'color',[1 1 0],'horizontalalignment','right','verticalalignment','bottom')
    end
	M=M/2;
end
hold off
return

%%%%%%%%%%%%%%%%%%%%%%%%%%

function w=waveletrescale(w,Niterations)
% w=waveletrescale(w,Niterations)
M=length(w);
epsilon=255*1e-8;

for j=1:Niterations
	n0=1:M/2;
	
	w0=w(n0+M/2,n0);
	moy=sum(sum(w0))/prod(size(w0));
	w0=w0-moy;
	m=max(max(abs(w0)));
	if m<=epsilon
		m=1;
	end
	w0=w0/m*127.5+127.5;
	w(n0+M/2,n0)=w0;

	w0=w(n0,n0+M/2);
	moy=sum(sum(w0))/prod(size(w0));
	w0=w0-moy;
	m=max(max(abs(w0)));
	if m<=epsilon
		m=1;
	end
	w0=w0/m*127.5+127.5;
	w(n0,n0+M/2)=w0;

	w0=w(n0+M/2,n0+M/2);
	moy=sum(sum(w0))/prod(size(w0));
	w0=w0-moy;
	m=max(max(abs(w0)));
	if m<=epsilon
		m=1;
	end
	w0=w0/m*127.5+127.5;
	w(n0+M/2,n0+M/2)=w0;
	
	M=M/2;
end

n0=1:M;
w0=w(n0,n0);
moy=sum(sum(w0))/prod(size(w0));
w0=w0-moy;
m=max(max(abs(w0)));
	if m<=epsilon
	m=1;
end
w0=w0/m*127.5+127.5;
w(n0,n0)=w0;
return