% Load a 1D signal
load 1Ddata
figure(1),plot(x)
set(gca,'fontsize',14)
title('Original signal')
M=length(x);      % Should be a power of 2

% Choose a fractional spline wavelet transform
alpha=2.4;          % Real value larger than -0.5
tau=0.3;            % Real value between -0.5 and +0.5
type='ortho';       % Options are:  1. 'bspline'
                    %               2. 'ortho'
                    %               3. 'dual'
[FFTanalysisfilters,FFTsynthesisfilters]=FFTfractsplinefilters(M,alpha,tau,type);

% Perform a fractional spline wavelet transform of the signal
J=4;                % Number of decomposition levels
w=FFTwaveletanalysis1D(x,FFTanalysisfilters,J);

% Show a subband
bandnumber=2;       
titletext=['Subband ' num2str(bandnumber)];
b0=wextract1D(w,J,bandnumber);
figure(2),clf,plot(b0),colormap(gray(256))
set(gca,'fontsize',14)
title(titletext)

% Show the whole wavelet transform
figure(3),clf,waveletplot1D(w,J)
set(gca,'fontsize',14)
title({['Fractional Spline Wavelet Transform (' num2str(J) ' levels)'],[type '-type, alpha=' num2str(alpha) ', tau=' num2str(tau)]})

% Reconstruction of the signal from its wavelet transform
x0=FFTwaveletsynthesis1D(w,FFTsynthesisfilters,J);
disp(['Resynthesis error: ' num2str(max(abs(x0(:)-x(:))))])

% Reconstruction from only one subband: use of the second output parameter
% from the function wextract2D.m
bandnumber=J+1;       
titletext=['Image resynthetized from the lowpass band at depth ' num2str(J)];
[b0,w0]=wextract1D(w,J,bandnumber);
x0=FFTwaveletsynthesis1D(w0,FFTsynthesisfilters,J);
figure(1),a=axis;
figure(4),clf,plot(x0),colormap(gray(256))
set(gca,'fontsize',14)
title(titletext)
axis(a)

% Plot of the synthesis scaling function and the wavelet
[x,y1]=fractsplinefunction(alpha,tau,type,10);
[x,y2]=fractsplinewaveletfunction(alpha,tau,type,10);
figure(5),plot(x,y1,'b',x,y2,'r')
set(gca,'fontsize',14)
legend('scaling function','wavelet')
title([type '-type, alpha=' num2str(alpha) ', tau=' num2str(tau)])