function sig_est=estimate_noise(im,Fs)
% SIG_EST=ESTIMATE_NOISE(IM)
% Estimate Gaussian white noise standard deviation with wavelet transform
% 
% Written by Hanjie Pan, October, 2011
% 
if nargin<2
    Fs=daubcqf(8,'mid');
end
[~,ch]=mrdwt(im,Fs,1);
n=size(im,2);
sub_hh=ch(:,2*n+1:3*n);
sig_est=median(abs(sub_hh(:)-median(sub_hh(:))))/0.6745;
return