function x_recon=TikhonovDecon(y,h_c,reg,option)
% Tikhonov regularized inverse
% Input:    y: blurred and noisy measurements
%           h_c: centered convolution filter of the same size of image
%           reg: regularization weight
%           option: use 'identity' or 'laplacian'
% Output:   x_recon: reconstructed image
if nargin<4
    option='identity';
end
if strcmpi(option,'identity')
    x_recon=ifft2(fft2(y).*conj(fft2(h_c))./(fft2(h_c).*conj(fft2(h_c))+reg.*ones(size(y))));
elseif strcmpi(option,'laplacian')
    P=[0 -1 0;-1 4 -1;0 -1 0];
    P_c=circshift(padarray(P,[size(y,1)-3 size(y,2)-3],0,'post'),[1 1]);
    x_recon=ifft2(fft2(y).*conj(fft2(h_c))./(fft2(h_c).*conj(fft2(h_c))+reg.*fft2(P_c).*conj(fft2(P_c))));
else
    error('Unrecognized option');
end
return