function A=fractsplineautocorr(alpha,nu) 
% 	Usage: A=fractsplineautocorr(alpha,nu) 
%
%   Frequency domain computation of the autocorrelation filter A(exp(2*i*Pi*nu)) 
% 	of a fractional spline of degree alpha (and dummy shift tau).  It uses an acceleration 
% 	technique to improve the convergence of the infinite sum by 4 orders (see Ref. [1]).
% 
% 	See also FFTFRACTSPLINEFILTERS
% 	
% 	Author: Thierry Blu
% 	The Chinese University of Hong Kong.
% 	This software is downloadable at http://www.ee.cuhk.edu.hk/~tblu/demos/
% 	
% 	References:
% 	[1] Unser, M. & Blu, T.,"Fractional Splines and Wavelets", SIAM Review, Vol. 42 (1), pp. 43-67, March 2000. 
% 	[2] Blu, T. & Unser, M.,"The Fractional Spline Wavelet Transform: Definition and Implementation", Proc. IEEE International 
%       Conference on Acoustics, Speech, and Signal Processing (ICASSP'00), Istanbul, Turkey, Vol. {I}, pp. 512-515, June 5--9, 2000.  
%   [3] Blu, T. & Unser, M.,"A Complete Family of Scaling Functions: The $($-Fractional Splines", Proc. IEEE International 
%       Conference on Acoustics, Speech, and Signal Processing (ICASSP'03), Hong Kong, China, Vol. {VI}, pp. 421-424, April 6--10, 2003. 
	
N=100;			% number of terms of the summation for computing
				% the autocorrelation frequency response

if alpha<=-0.5
	disp('The autocorrelation of the fractional splines exists only ')
	disp('for degrees strictly larger than -0.5!')
	A=[];
	return
end
				
S=zeros(1,length(nu));
err=[];
err0=[];
for n=-N:N
	S=S+abs(sinc(nu+n)).^(2*alpha+2);
end
U=2/(2*alpha+1)/N^(2*alpha+1);
U=U-1/N^(2*alpha+2);
U=U+(alpha+1)*(1/3+2*nu.*nu)/N^(2*alpha+3);
U=U-(alpha+1)*(2*alpha+3)*nu.*nu/N^(2*alpha+4);
U=U.*abs(sin(pi*nu)/pi).^(2*alpha+2);
A=S+U;
